/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.heads;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

@Name(value="URL of Head")
@Description(value={"Gets the URL of a head"})
@Since(value={"1.0.7"})
@Examples(value={"broadcast url of {_head}"})
public class ExprURLOfHead
extends SimplePropertyExpression<ItemStack, String> {
    @Nullable
    public String convert(ItemStack from) {
        if (from != null && from.getType() == Material.PLAYER_HEAD) {
            SkullMeta meta = (SkullMeta)from.getItemMeta();
            String url = meta.getOwnerProfile().getTextures().getSkin().toString();
            return url;
        }
        return null;
    }

    protected String getPropertyName() {
        return "url of head";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprURLOfHead.register(ExprURLOfHead.class, String.class, (String)"url", (String)"itemstack");
    }
}

