/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.items.other;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.ExpressionType;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Smelted Form")
@Description(value={"Returns the smelted form of an itemtype.", "If it cannot be smelted, it will return the same itemtype."})
@Since(value={"1.2.1"})
@Examples(value={"give player the smelted form of raw iron"})
public class ExprSmelted
extends SimplePropertyExpression<ItemType, ItemType> {
    private ItemStack smelted(ItemStack item) {
        Material type = item.getType();
        @NotNull Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            FurnaceRecipe recipe;
            Material ingredient;
            Object e = it.next();
            if (!(e instanceof FurnaceRecipe) || type != (ingredient = (recipe = (FurnaceRecipe)e).getInput().getType())) continue;
            ItemStack result = item.clone();
            result.setType(recipe.getResult().getType());
            return result;
        }
        return item;
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "smelted form";
    }

    @Nullable
    public ItemType convert(ItemType itemType) {
        return new ItemType(this.smelted(itemType.getRandom()));
    }

    static {
        Skript.registerExpression(ExprSmelted.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] smelt[ed] [(result|form) of] %itemtypes%", "%itemtypes%'[s] smelted [(result|form)]", "%itemtypes% smelted"});
    }
}

