/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.util;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.util.Config;
import au.nagasonic.skonic.elements.util.Util;
import ch.njol.skript.util.Version;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker
implements Listener {
    private final Skonic plugin;
    private final Version pluginVersion;
    private Version currentUpdateVersion;

    public UpdateChecker(Skonic plugin) {
        this.plugin = plugin;
        this.pluginVersion = new Version(plugin.getDescription().getVersion());
        Config config = plugin.getPluginConfig();
        if (config.SETTINGS_UPDATE_CHECKER_ENABLED) {
            this.setupJoinListener();
            this.checkUpdate(false);
        } else {
            Util.log("&3Update checker disabled!", new Object[0]);
        }
    }

    private void setupJoinListener() {
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            private void onJoin(PlayerJoinEvent event) {
                Player player = event.getPlayer();
                if (!player.hasPermission("skonic.update.check")) {
                    return;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)UpdateChecker.this.plugin, () -> UpdateChecker.this.getUpdateVersion(true).thenApply(version -> {
                    Util.sendColMsg((CommandSender)player, "&7[&9Skonic&7] Update available: &a" + version, new Object[0]);
                    Util.sendColMsg((CommandSender)player, "&7[&9Skonic&7] Download at &bhttps://modrinth.com/plugin/skonic/versions", new Object[0]);
                    return true;
                }), 30L);
            }
        }, (Plugin)this.plugin);
    }

    private void checkUpdate(boolean async) {
        Util.log("Checking for update...", new Object[0]);
        ((CompletableFuture)this.getUpdateVersion(async).thenApply(version -> {
            Util.logLoading("&cPlugin is not up to date!", new Object[0]);
            Util.logLoading(" - Current version: &cv%s", this.pluginVersion);
            Util.logLoading(" - Available update: &av%s", version);
            Util.logLoading(" - Download available at: https://modrinth.com/plugin/skonic/versions", new Object[0]);
            return true;
        })).exceptionally(throwable -> {
            Util.logLoading("&aPlugin is up to date!", new Object[0]);
            return true;
        });
    }

    private CompletableFuture<Version> getUpdateVersion(boolean async) {
        CompletableFuture<Version> future = new CompletableFuture<Version>();
        if (this.currentUpdateVersion != null) {
            future.complete(this.currentUpdateVersion);
        } else {
            this.getLatestReleaseVersion(async).thenApply(version -> {
                if (version.compareTo(this.pluginVersion) <= 0) {
                    future.cancel(true);
                } else {
                    this.currentUpdateVersion = version;
                    future.complete(this.currentUpdateVersion);
                }
                return true;
            });
        }
        return future;
    }

    private CompletableFuture<Version> getLatestReleaseVersion(boolean async) {
        CompletableFuture<Version> future = new CompletableFuture<Version>();
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                Version lastest = this.getLastestVersionFromModrinth();
                if (lastest == null) {
                    future.cancel(true);
                }
                future.complete(lastest);
            });
        } else {
            Version latest = this.getLastestVersionFromModrinth();
            if (latest == null) {
                future.cancel(true);
            }
            future.complete(latest);
        }
        return future;
    }

    @Nullable
    private Version getLastestVersionFromModrinth() {
        try {
            URL url = new URL("https://api.modrinth.com/v3/project/Skonic/version");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            JsonArray jsonArray = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
            JsonObject jsonObject = jsonArray.get(0).getAsJsonObject();
            String tag_name = jsonObject.get("version_number").getAsString();
            return new Version(tag_name);
        }
        catch (IOException e) {
            if (this.plugin.getPluginConfig().SETTINGS_DEBUG) {
                e.printStackTrace();
            } else {
                Util.logLoading("&cChecking for update failed!", new Object[0]);
            }
            return null;
        }
    }
}

