/*
 * Decompiled with CFR 0.152.
 */
package com.copicraftDev.copisAnalyticsPlugin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CopisAnalyticsPlugin
extends JavaPlugin
implements Listener {
    private File dataFile;
    private FileConfiguration data;
    private long serverStart;
    private final long[] tickTimes = new long[100];
    private int tickIndex = 0;

    public void onEnable() {
        this.getLogger().info("CopisAnalytics v1.2 enabled!");
        this.serverStart = System.currentTimeMillis();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            this.dataFile.getParentFile().mkdirs();
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.data.set(String.valueOf(player.getUniqueId()) + ".lastJoin", (Object)System.currentTimeMillis());
            if (this.data.get(String.valueOf(player.getUniqueId()) + ".totalPlaytime") != null) continue;
            this.data.set(String.valueOf(player.getUniqueId()) + ".totalPlaytime", (Object)0L);
        }
        this.startTickTracking();
        this.saveData();
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updatePlaytime(player);
        }
        this.saveData();
        this.getLogger().info("CopisAnalytics disabled!");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.data.set(String.valueOf(player.getUniqueId()) + ".lastJoin", (Object)System.currentTimeMillis());
        if (this.data.get(String.valueOf(player.getUniqueId()) + ".totalPlaytime") == null) {
            this.data.set(String.valueOf(player.getUniqueId()) + ".totalPlaytime", (Object)0L);
        }
        this.saveData();
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.updatePlaytime(player);
        this.saveData();
    }

    private void updatePlaytime(Player player) {
        long lastJoin = this.data.getLong(String.valueOf(player.getUniqueId()) + ".lastJoin");
        long total = this.data.getLong(String.valueOf(player.getUniqueId()) + ".totalPlaytime");
        this.data.set(String.valueOf(player.getUniqueId()) + ".totalPlaytime", (Object)(total += System.currentTimeMillis() - lastJoin));
    }

    private void saveData() {
        if (this.data != null && this.dataFile != null) {
            try {
                this.data.save(this.dataFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void startTickTracking() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            this.tickTimes[this.tickIndex % this.tickTimes.length] = System.currentTimeMillis();
            ++this.tickIndex;
        }, 0L, 1L);
    }

    private double getTPS() {
        int count = Math.min(this.tickIndex, this.tickTimes.length - 1);
        if (count < 1) {
            return 20.0;
        }
        long first = this.tickTimes[(this.tickIndex - count + this.tickTimes.length) % this.tickTimes.length];
        long last = this.tickTimes[(this.tickIndex - 1 + this.tickTimes.length) % this.tickTimes.length];
        double averageTickTime = (double)(last - first) / (double)count;
        return Math.min(1000.0 / averageTickTime, 20.0);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (command.getName().toLowerCase()) {
            case "playtime": {
                this.handlePlaytime(sender, args);
                return true;
            }
            case "tps": 
            case "tickrate": {
                this.handleTPS(sender);
                return true;
            }
            case "uptime": {
                this.handleUptime(sender);
                return true;
            }
            case "topplaytime": {
                this.handleTopPlaytime(sender);
                return true;
            }
            case "onlinecount": {
                this.handleOnlineCount(sender);
                return true;
            }
            case "resetstats": {
                this.handleResetStats(sender, args);
                return true;
            }
        }
        return false;
    }

    private void handlePlaytime(CommandSender sender, String[] args) {
        Player targetPlayer;
        if (!(sender instanceof Player) && args.length < 1) {
            sender.sendMessage("\u00a7cConsole must specify a player: /playtime <player>");
            return;
        }
        if (args.length >= 1) {
            Player online = Bukkit.getPlayer((String)args[0]);
            if (online != null) {
                targetPlayer = online;
            } else {
                targetPlayer = Bukkit.getOfflinePlayer((String)args[0]);
                if (!targetPlayer.hasPlayedBefore() && !targetPlayer.isOnline()) {
                    sender.sendMessage("\u00a7cPlayer not found!");
                    return;
                }
            }
        } else {
            targetPlayer = (Player)sender;
        }
        UUID uuid = targetPlayer.getUniqueId();
        long totalPlaytime = this.data.getLong(String.valueOf(uuid) + ".totalPlaytime");
        if (targetPlayer.isOnline()) {
            totalPlaytime += System.currentTimeMillis() - this.data.getLong(String.valueOf(uuid) + ".lastJoin");
        }
        sender.sendMessage("\u00a7aPlaytime of \u00a7e" + targetPlayer.getName() + "\u00a7a: " + this.formatMillis(totalPlaytime));
    }

    private void handleTPS(CommandSender sender) {
        double tps = this.getTPS();
        sender.sendMessage("\u00a7aCurrent TPS: \u00a7e" + String.format("%.2f", tps));
    }

    private void handleUptime(CommandSender sender) {
        long uptime = System.currentTimeMillis() - this.serverStart;
        sender.sendMessage("\u00a7aServer uptime: \u00a7e" + this.formatMillis(uptime));
    }

    private void handleTopPlaytime(CommandSender sender) {
        HashMap<UUID, Long> playtimeMap = new HashMap<UUID, Long>();
        for (String key : this.data.getKeys(false)) {
            if (!key.endsWith(".totalPlaytime")) continue;
            UUID uuid = UUID.fromString(key.split("\\.")[0]);
            playtimeMap.put(uuid, this.data.getLong(key));
        }
        List sorted = playtimeMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).collect(Collectors.toList());
        sender.sendMessage("\u00a7aTop Playtime:");
        int rank = 1;
        for (Map.Entry entry : sorted) {
            OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
            sender.sendMessage("\u00a7e" + rank + ". " + p.getName() + " \u00a7a- " + this.formatMillis((Long)entry.getValue()));
            ++rank;
        }
    }

    private void handleOnlineCount(CommandSender sender) {
        sender.sendMessage("\u00a7aOnline players: \u00a7e" + Bukkit.getOnlinePlayers().size() + "\u00a7a/" + Bukkit.getMaxPlayers());
    }

    private void handleResetStats(CommandSender sender, String[] args) {
        if (!sender.hasPermission("copisanalytics.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to reset stats.");
            return;
        }
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /resetstats <player>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        UUID uuid = target.getUniqueId();
        this.data.set(String.valueOf(uuid) + ".totalPlaytime", (Object)0L);
        this.data.set(String.valueOf(uuid) + ".lastJoin", null);
        this.saveData();
        sender.sendMessage("\u00a7aStats for \u00a7e" + target.getName() + " \u00a7ahave been reset.");
    }

    private String formatMillis(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        return days + "d " + (hours %= 24L) + "h " + (minutes %= 60L) + "m " + (seconds %= 60L) + "s";
    }
}

