/*
 * Decompiled with CFR 0.152.
 */
package com.copicraftDev.copis_analytics_mod;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Copis_analytics_mod
implements ModInitializer {
    public static final String MOD_ID = "copisanalyticsmod";
    private final Map<UUID, Long> playtime = new HashMap<UUID, Long>();
    private final Map<UUID, Long> joinTime = new HashMap<UUID, Long>();
    private long serverStart;
    private double tps = 20.0;
    private long lastTick = System.currentTimeMillis();
    private int tickCounter = 0;
    private File saveFile;
    private final Gson gson = new Gson();

    public void onInitialize() {
        this.serverStart = System.currentTimeMillis();
        this.saveFile = new File("config", "copis_analytics.json");
        this.loadPlaytime();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.joinTime.put(handler.field_14140.method_5667(), System.currentTimeMillis()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            UUID uuid = handler.field_14140.method_5667();
            long joinedAt = this.joinTime.getOrDefault(uuid, System.currentTimeMillis());
            this.playtime.put(uuid, this.playtime.getOrDefault(uuid, 0L) + (System.currentTimeMillis() - joinedAt));
            this.joinTime.remove(uuid);
            this.savePlaytime();
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            ++this.tickCounter;
            long now = System.currentTimeMillis();
            if (now - this.lastTick >= 1000L) {
                this.tps = (double)this.tickCounter / ((double)(now - this.lastTick) / 1000.0);
                this.tickCounter = 0;
                this.lastTick = now;
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"playtime").executes(context -> {
                class_3222 player = ((class_2168)context.getSource()).method_44023();
                long time = this.getPlaytime(player);
                player.method_7353(class_2561.method_30163((String)("Playtime: " + this.formatMillis(time))), false);
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"uptime").executes(context -> {
                class_3222 player = ((class_2168)context.getSource()).method_44023();
                long uptime = System.currentTimeMillis() - this.serverStart;
                player.method_7353(class_2561.method_30163((String)("Server uptime: " + this.formatMillis(uptime))), false);
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tps").executes(context -> {
                class_3222 player = ((class_2168)context.getSource()).method_44023();
                player.method_7353(class_2561.method_30163((String)("TPS: " + String.format("%.2f", this.tps))), false);
                return 1;
            }));
        });
    }

    private long getPlaytime(class_3222 player) {
        UUID uuid = player.method_5667();
        long total = this.playtime.getOrDefault(uuid, 0L);
        if (this.joinTime.containsKey(uuid)) {
            total += System.currentTimeMillis() - this.joinTime.get(uuid);
        }
        return total;
    }

    private String formatMillis(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        return days + "d " + (hours %= 24L) + "h " + (minutes %= 60L) + "m " + (seconds %= 60L) + "s";
    }

    private void savePlaytime() {
        try {
            if (!this.saveFile.getParentFile().exists()) {
                this.saveFile.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(this.saveFile);
            this.gson.toJson(this.playtime, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPlaytime() {
        try {
            if (!this.saveFile.exists()) {
                return;
            }
            FileReader reader = new FileReader(this.saveFile);
            Type type = new TypeToken<Map<UUID, Long>>(this){}.getType();
            Map raw = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<UUID, Double>>(this){}.getType());
            reader.close();
            if (raw != null) {
                raw.forEach((uuid, val) -> this.playtime.put((UUID)uuid, val.longValue()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

