/*
 * Decompiled with CFR 0.152.
 */
package tr4nt.autofish.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigFile {
    private static String fileName;
    private static Path path;
    private static Path configFilePath;

    public static void register(String file) {
        fileName = "/" + file + ".json";
        configFilePath = Paths.get(path.toString() + fileName, new String[0]);
        if (!ConfigFile.checkFile(path.toString() + fileName)) {
            try {
                ConfigFile.createConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static File getFile(String path) {
        return new File(path);
    }

    private static boolean checkFile(String path) {
        return ConfigFile.getFile(path).exists();
    }

    private static void createConfig() throws IOException {
        File f = new File(configFilePath.toString());
        if (f.createNewFile()) {
            PrintWriter filewrite = new PrintWriter(path.toString() + fileName);
            filewrite.write("{}");
            filewrite.close();
        }
    }

    public static void addValue(Map<String, String> vals, boolean replace) {
        String s = null;
        try {
            s = Files.readString(configFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonObject obj = JsonParser.parseString((String)s).getAsJsonObject();
        String key = (String)vals.keySet().toArray()[0];
        JsonElement value = JsonParser.parseString((String)((String)vals.values().toArray()[0]));
        if (!obj.has(key)) {
            obj.add(key, value);
        } else if (replace) {
            obj.remove(key);
            obj.add(key, value);
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(configFilePath.toString());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        pw.write(obj.toString());
        pw.close();
        ConfigFile.format();
    }

    public static JsonElement getValue(String key) {
        String s = null;
        try {
            s = Files.readString(configFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonObject obj = JsonParser.parseString((String)s).getAsJsonObject();
        return obj.get(key);
    }

    private static void format() {
        Object buff = "";
        String s = null;
        try {
            s = Files.readString(configFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < s.length(); ++i) {
            char prevChar;
            char c = s.charAt(i);
            if (i != 0 && ((prevChar = s.charAt(i - 1)) == ',' || prevChar == '{' || i == s.length() - 1)) {
                buff = i == s.length() - 1 ? (String)buff + "\n" : (String)buff + "\n\t";
            }
            buff = (String)buff + c;
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(configFilePath.toString());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        pw.write((String)buff);
        pw.close();
    }

    static {
        path = FabricLoader.getInstance().getConfigDir();
    }
}

