/*
 * Decompiled with CFR 0.152.
 */
package endattack;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandVisibilityPlugin
extends JavaPlugin
implements Listener {
    private Set<String> shownCommands = new HashSet<String>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("CommandVisibilityPlugin has been enabled.");
    }

    private void loadConfigData() {
        this.shownCommands.clear();
        if (this.getConfig().isList("shown-commands")) {
            this.shownCommands.addAll(this.getConfig().getStringList("shown-commands"));
        }
    }

    @EventHandler
    public void onCommandSend(PlayerCommandSendEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("commandvisibility.bypass")) {
            return;
        }
        HashSet<String> allowed = new HashSet<String>();
        for (String command : event.getCommands()) {
            String base = command.split(":")[0].toLowerCase();
            if (!this.shownCommands.contains(base)) continue;
            allowed.add(command);
        }
        event.getCommands().retainAll(allowed);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("commandvisibility") && args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            Player player;
            if (sender instanceof Player && !(player = (Player)sender).hasPermission("commandvisibility.reload")) {
                player.sendMessage("\u00a7cYou do not have permission to execute this command.");
                return true;
            }
            this.reloadConfig();
            this.loadConfigData();
            sender.sendMessage("\u00a7aCommandVisibilityPlugin has been reloaded successfully.");
            return true;
        }
        return false;
    }
}

