/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.Blocks.Plants;

import com.mojang.serialization.MapCodec;
import net.corespring.cslibrary.Blocks.Plants.CSBushBlocks;
import net.corespring.cslibrary.Registry.CSItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class CSCottonPlant
extends CSBushBlocks
implements BonemealableBlock {
    public static final MapCodec<CSCottonPlant> CODEC = CSCottonPlant.simpleCodec(CSCottonPlant::new);
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape SAPLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public MapCodec<CSCottonPlant> codec() {
        return CODEC;
    }

    public CSCottonPlant(BlockBehaviour.Properties p_57249_) {
        super(p_57249_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)CSItems.COTTON.get());
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if ((Integer)pState.getValue((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return (Integer)pState.getValue((Property)AGE) < 3 ? MID_GROWTH_SHAPE : super.getShape(pState, pLevel, pPos, pContext);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = (Integer)pState.getValue((Property)AGE);
        if (i < 3 && pLevel.getRawBrightness(pPos.above(), 0) >= 9 && CommonHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            pLevel.setBlock(pPos, blockstate, 2);
            pLevel.gameEvent(GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)blockstate));
            CommonHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        boolean flag;
        int i = (Integer)pState.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && pPlayer.getItemInHand(pHand).is(Items.BONE_MEAL)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + pLevel.random.nextInt(2);
            CSCottonPlant.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)CSItems.COTTON.get(), j + (flag ? 1 : 0)));
            pLevel.playSound(null, pPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.4f + pLevel.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            pLevel.setBlock(pPos, blockstate, 2);
            pLevel.gameEvent(GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)pPlayer, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return super.use(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int i = Math.min(3, (Integer)pState.getValue((Property)AGE) + 1);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

