/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.Items.BeakerItems;

import javax.annotation.Nonnull;
import net.corespring.cslibrary.Registry.CSItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BeakerItem
extends Item {
    public BeakerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (itemstack.getItem() == CSItems.BEAKER_WATER.get()) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockHitResult blockhitresult = BeakerItem.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockhitresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = blockhitresult.getBlockPos();
            if (!pLevel.mayInteract(pPlayer, blockpos)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (pLevel.getFluidState(blockpos).is(FluidTags.WATER)) {
                pLevel.playSound(pPlayer, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                pLevel.gameEvent((Entity)pPlayer, GameEvent.FLUID_PICKUP, blockpos);
                return InteractionResultHolder.sidedSuccess((Object)this.turnBottleIntoItem(itemstack, pPlayer, new ItemStack((ItemLike)CSItems.BEAKER_WATER.get())), (boolean)pLevel.isClientSide());
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return new ItemStack((ItemLike)CSItems.BEAKER.get());
    }

    protected ItemStack turnBottleIntoItem(ItemStack pBottleStack, Player pPlayer, ItemStack pFilledBottleStack) {
        return ItemUtils.createFilledResult((ItemStack)pBottleStack, (Player)pPlayer, (ItemStack)pFilledBottleStack);
    }
}

