/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.Items.Enchantments;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;

public class TridentDamageEnchantment
extends Enchantment {
    public TridentDamageEnchantment(Enchantment.Rarity pRarity, EnchantmentCategory pCategory, EquipmentSlot ... pApplicableSlots) {
        super(pRarity, pCategory, pApplicableSlots);
    }

    public boolean checkCompatibility(Enchantment pEnch) {
        return super.checkCompatibility(pEnch) && pEnch != Enchantments.IMPALING;
    }

    public int getMinCost(int pEnchantmentLevel) {
        return 1 + (pEnchantmentLevel - 1) * 10;
    }

    public int getMaxCost(int pEnchantmentLevel) {
        return this.getMinCost(pEnchantmentLevel) + 20;
    }

    public int getMaxLevel() {
        return 5;
    }

    public float getDamageBonus(int level, MobType mobType, ItemStack enchantedItem) {
        return mobType == MobType.UNDEFINED ? 1.0f + (float)Math.max(0, level - 1) * 0.5f : 0.0f;
    }
}

