/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.Entities;

import net.corespring.cslibrary.Registry.CSEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.fluids.FluidType;

public class RadioactiveDrowned
extends Drowned
implements RangedAttackMob {
    public RadioactiveDrowned(EntityType<? extends RadioactiveDrowned> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.28f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ARMOR, 2.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    public static boolean checkRadioactiveDrownedSpawnRules(EntityType<RadioactiveDrowned> pRadioactiveDrowned, ServerLevelAccessor pServerLevel, MobSpawnType pMobSpawnType, BlockPos pPos, RandomSource pRandom) {
        boolean flag;
        if (!pServerLevel.getFluidState(pPos.below()).is(FluidTags.WATER) && !MobSpawnType.isSpawner((MobSpawnType)pMobSpawnType)) {
            return false;
        }
        Holder holder = pServerLevel.getBiome(pPos);
        boolean bl = flag = !(pServerLevel.getDifficulty() == Difficulty.PEACEFUL || !MobSpawnType.ignoresLightRequirements((MobSpawnType)pMobSpawnType) && !RadioactiveDrowned.isDarkEnoughToSpawn((ServerLevelAccessor)pServerLevel, (BlockPos)pPos, (RandomSource)pRandom) || !MobSpawnType.isSpawner((MobSpawnType)pMobSpawnType) && !pServerLevel.getFluidState(pPos).is(FluidTags.WATER));
        if (flag && MobSpawnType.isSpawner((MobSpawnType)pMobSpawnType)) {
            return true;
        }
        if (holder.is(BiomeTags.MORE_FREQUENT_DROWNED_SPAWNS)) {
            return pRandom.nextInt(15) == 0 && flag;
        }
        return pRandom.nextInt(40) == 0 && RadioactiveDrowned.isDeepEnoughToSpawn((LevelAccessor)pServerLevel, pPos) && flag;
    }

    private static boolean isDeepEnoughToSpawn(LevelAccessor pLevel, BlockPos pPos) {
        return pPos.getY() < pLevel.getSeaLevel() - 5;
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.DROWNED_AMBIENT_WATER;
    }

    public boolean canDrownInFluidType(FluidType pFluidType) {
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.DROWNED_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.DROWNED_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.DROWNED_STEP;
    }

    public boolean doHurtTarget(Entity pEntity) {
        boolean flag = super.doHurtTarget(pEntity);
        if (flag && this.getMainHandItem().isEmpty() && pEntity instanceof LivingEntity) {
            float f = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)pEntity).addEffect(new MobEffectInstance(CSEffects.RADIATION_POISONING.get(), 120, 1), (Entity)this);
        }
        return flag;
    }
}

