/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.Utils.Radiation;

import net.corespring.cslibrary.Utils.Radiation.RadioactiveItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Radiation
extends Entity {
    private static final EntityDataAccessor<Integer> RADIATION_LEVEL = SynchedEntityData.defineId(Radiation.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MAX_RADIATION_LEVEL = 100;
    private int radiationLevel = 0;
    private final Player player;

    public Radiation(EntityType<?> entityType, Level world, Player player) {
        super(entityType, world);
        this.player = player;
    }

    protected void defineSynchedData() {
        this.entityData.define(RADIATION_LEVEL, (Object)0);
    }

    public void tick() {
        System.out.println("Tick method called for Radiation entity.");
        if (!this.isAlive()) {
            System.out.println("Radiation entity is not alive.");
            return;
        }
        if (this.player != null) {
            System.out.println("Player is not null.");
            if (this.hasRadioactiveItems()) {
                System.out.println("Player has radioactive items.");
                this.increaseRadiation();
            } else {
                System.out.println("Player does not have radioactive items.");
                this.decreaseRadiation();
            }
            this.updateRadiationLevel();
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("RadiationLevel")) {
            this.entityData.set(RADIATION_LEVEL, (Object)compound.getInt("RadiationLevel"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("RadiationLevel", ((Integer)this.entityData.get(RADIATION_LEVEL)).intValue());
    }

    private boolean hasRadioactiveItems() {
        for (ItemStack itemStack : this.player.getInventory().items) {
            if (!RadioactiveItems.isRadioactive(itemStack.getItem())) continue;
            System.out.println("Increased radiation to: " + this.radiationLevel);
            return true;
        }
        System.out.println("Player does not have radioactive items.");
        return false;
    }

    private void increaseRadiation() {
        if (this.radiationLevel < 100) {
            ++this.radiationLevel;
            this.setRadiationLevel(this.radiationLevel);
            System.out.println("Increased radiation to: " + this.radiationLevel);
        }
    }

    private void decreaseRadiation() {
        if (this.radiationLevel > 0) {
            --this.radiationLevel;
            this.setRadiationLevel(this.radiationLevel);
        }
    }

    private void updateRadiationLevel() {
        this.entityData.set(RADIATION_LEVEL, (Object)this.radiationLevel);
        this.player.getPersistentData().putInt(this.player.getUUID().toString() + "RadiationLevel", this.radiationLevel);
        System.out.println("Updating radiation to: " + this.radiationLevel);
    }

    void setRadiationLevel(int newRadiationLevel) {
        this.radiationLevel = Math.max(0, Math.min(newRadiationLevel, 100));
        System.out.println("Setting radiation to: " + this.radiationLevel);
    }

    public static int getRadiationLevel(Player player) {
        return player.getPersistentData().getInt(player.getUUID().toString() + "RadiationLevel");
    }
}

