/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary;

import com.mojang.logging.LogUtils;
import net.corespring.cslibrary.Entities.RadioactiveDrownedRenderer;
import net.corespring.cslibrary.Entities.RadioactivePiglinRenderer;
import net.corespring.cslibrary.Entities.RadioactiveZombieRenderer;
import net.corespring.cslibrary.Items.Curios.CurioRegistry;
import net.corespring.cslibrary.Registry.CSBlocks;
import net.corespring.cslibrary.Registry.CSCreativeTab;
import net.corespring.cslibrary.Registry.CSEffects;
import net.corespring.cslibrary.Registry.CSEnchantments;
import net.corespring.cslibrary.Registry.CSEntities;
import net.corespring.cslibrary.Registry.CSItems;
import net.corespring.cslibrary.Registry.CSLootModifiers;
import net.corespring.cslibrary.Registry.CSPotions;
import net.corespring.cslibrary.Utils.CSBrewingRecipe;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.brewing.BrewingRecipeRegistry;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="cslibrary")
public class CSLibrary {
    public static final String MOD_ID = "cslibrary";
    private static final Logger LOGGER = LogUtils.getLogger();

    public CSLibrary(IEventBus modEventBus) {
        modEventBus.addListener(this::commonSetup);
        CSItems.register(modEventBus);
        CSBlocks.register(modEventBus);
        CSEnchantments.register(modEventBus);
        CSLootModifiers.register(modEventBus);
        CSEffects.register(modEventBus);
        CSPotions.register(modEventBus);
        CSEntities.register(modEventBus);
        CSCreativeTab.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new CSBrewingRecipe(CSItems.BEAKER_WATER.get(), CSBlocks.ACID_MUSHROOM.get(), CSItems.BEAKER_BATTERY_ACID.get())));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="cslibrary", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.DEDICATED_SERVER})
    public static class serverModEvents {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            event.getGenerator().addProvider(event.includeServer(), (DataProvider)new CurioRegistry(CSLibrary.MOD_ID, event.getGenerator().getPackOutput(), event.getExistingFileHelper(), event.getLookupProvider()));
        }
    }

    @Mod.EventBusSubscriber(modid="cslibrary", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ItemBlockRenderTypes.setRenderLayer((Block)CSBlocks.AMBER_GLASS.get(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)CSBlocks.STEEL_GLASS.get(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)CSBlocks.LEAD_GLASS.get(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)CSBlocks.STEEL_MESH.get(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)CSBlocks.RUSTED_STEEL_MESH.get(), (RenderType)RenderType.translucent());
            EntityRenderers.register(CSEntities.RADIOACTIVE_ZOMBIE.get(), RadioactiveZombieRenderer::new);
            EntityRenderers.register(CSEntities.RADIOACTIVE_DROWNED.get(), RadioactiveDrownedRenderer::new);
            EntityRenderers.register(CSEntities.RADIOACTIVE_PIGLIN.get(), context -> new RadioactivePiglinRenderer(context, ModelLayers.ZOMBIFIED_PIGLIN, ModelLayers.ZOMBIFIED_PIGLIN_INNER_ARMOR, ModelLayers.ZOMBIFIED_PIGLIN_OUTER_ARMOR, false));
        }
    }
}

