/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.DataGen;

import java.util.concurrent.CompletableFuture;
import net.corespring.cslibrary.DataGen.CSBlockStateProvider;
import net.corespring.cslibrary.DataGen.CSBlockTagGenerator;
import net.corespring.cslibrary.DataGen.CSGlobalLootModifiersProvider;
import net.corespring.cslibrary.DataGen.CSItemModelProvider;
import net.corespring.cslibrary.DataGen.CSItemTagGenerator;
import net.corespring.cslibrary.DataGen.CSLootTableProvider;
import net.corespring.cslibrary.DataGen.CSWorldGenProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod.EventBusSubscriber(modid="cslibrary", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)CSLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new CSBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new CSItemModelProvider(packOutput, existingFileHelper));
        CSBlockTagGenerator blockTagGenerator = (CSBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new CSBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CSItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CSWorldGenProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new CSGlobalLootModifiersProvider(packOutput));
    }
}

