/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.Items.Curios;

import java.util.List;
import net.corespring.cslibrary.Items.Curios.SimpleCurioItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SimpleCurioWDescription
extends SimpleCurioItem {
    @Nullable
    final String slotIdentifier;
    Style descriptionStyle;
    boolean showHeader;

    public SimpleCurioWDescription(Item.Properties properties, String slotIdentifier) {
        super(properties);
        this.slotIdentifier = slotIdentifier;
        this.showHeader = true;
        this.descriptionStyle = Style.EMPTY.withColor(ChatFormatting.YELLOW);
    }

    public SimpleCurioWDescription(Item.Properties properties) {
        this(properties, null);
    }

    public List<Component> getSlotsTooltip(List<Component> tooltips, ItemStack stack) {
        if (this.slotIdentifier != null) {
            MutableComponent title = Component.translatable((String)("curios.modifiers." + this.slotIdentifier)).withStyle(ChatFormatting.GOLD);
            if (this.showHeader) {
                tooltips.add((Component)Component.empty());
                tooltips.add((Component)title);
            }
            tooltips.addAll(this.getDescriptionLines(stack));
        }
        return super.getSlotsTooltip(tooltips, stack);
    }

    public List<Component> getDescriptionLines(ItemStack stack) {
        return List.of(this.getDescription(stack));
    }

    public Component getDescription(ItemStack stack) {
        return Component.literal((String)" ").append((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"))).withStyle(this.descriptionStyle);
    }
}

