/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.Registry;

import java.util.function.Supplier;
import net.corespring.cslibrary.Registry.CSItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum CSArmorTiers implements ArmorMaterial
{
    OPAL("opal", 42, new int[]{5, 9, 7, 4}, 15, SoundEvents.ARMOR_EQUIP_DIAMOND, 3.0f, 0.25f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)CSItems.OPAL_CRYSTAL.get()})),
    PLATINUM("platinum", 52, new int[]{5, 9, 7, 4}, 18, SoundEvents.ARMOR_EQUIP_NETHERITE, 3.0f, 0.25f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)CSItems.INGOT_PLATINUM.get()})),
    TITANIUM("titanium", 98, new int[]{6, 12, 10, 5}, 23, SoundEvents.ARMOR_EQUIP_NETHERITE, 6.0f, 0.45f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)CSItems.INGOT_TITANIUM.get()})),
    BLACK_DIAMOND("black_diamond", 37, new int[]{3, 8, 6, 3}, 8, SoundEvents.ARMOR_EQUIP_DIAMOND, 1.0f, 0.05f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)CSItems.BLACK_DIAMOND_CRYSTAL.get()})),
    STEEL("steel", 35, new int[]{3, 7, 6, 3}, 8, SoundEvents.ARMOR_EQUIP_IRON, 3.0f, 0.25f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)CSItems.INGOT_STEEL.get()}));

    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionAmounts;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;
    private static final int[] BASE_DURABILITY;

    private CSArmorTiers(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantmentValue, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int getDurabilityForType(ArmorItem.Type pType) {
        return BASE_DURABILITY[pType.ordinal()] * this.durabilityMultiplier;
    }

    public int getDefenseForType(ArmorItem.Type pType) {
        return this.protectionAmounts[pType.ordinal()];
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public SoundEvent getEquipSound() {
        return this.equipSound;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    public String getName() {
        return "cslibrary:" + this.name;
    }

    public float getToughness() {
        return this.toughness;
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    static {
        BASE_DURABILITY = new int[]{11, 16, 16, 13};
    }
}

