/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.cslibrary.Block.BlockEntities;

import net.corespring.cslibrary.Registry.CSBlockEntities;
import net.corespring.cslibrary.Registry.CSItems;
import net.corespring.cslibrary.Screens.NeutronActivatorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutronActivatorBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            NeutronActivatorBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> NeutronActivatorBlockEntity.this.progress;
                case 1 -> NeutronActivatorBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    NeutronActivatorBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    NeutronActivatorBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;

    public NeutronActivatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)CSBlockEntities.NEUTRON_ACTIVATOR.get(), pPos, pBlockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"screen.cslibrary.neutron_activator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new NeutronActivatorMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, NeutronActivatorBlockEntity pEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (NeutronActivatorBlockEntity.hasRecipe(pEntity)) {
            ++pEntity.progress;
            NeutronActivatorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            if (pEntity.progress >= pEntity.maxProgress) {
                NeutronActivatorBlockEntity.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            NeutronActivatorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(NeutronActivatorBlockEntity pEntity) {
        if (NeutronActivatorBlockEntity.hasRecipe(pEntity)) {
            pEntity.itemHandler.extractItem(1, 1, false);
            pEntity.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)CSItems.INGOT_STEEL.get(), pEntity.itemHandler.getStackInSlot(2).m_41613_() + 1));
            pEntity.resetProgress();
        }
    }

    private static boolean hasRecipe(NeutronActivatorBlockEntity entity) {
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        boolean hasUraniumInFirstSlot = entity.itemHandler.getStackInSlot(1).m_41720_() == CSItems.INGOT_URANIUM.get();
        return hasUraniumInFirstSlot && NeutronActivatorBlockEntity.canInsertAmountIntoOutputSlot(inventory) && NeutronActivatorBlockEntity.canInsertItemIntoOutputSlot(inventory, new ItemStack((ItemLike)CSItems.INGOT_STEEL.get(), 1));
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.m_8020_(2).m_41720_() == stack.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_();
    }
}

