/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.chatplusforge.procedures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigProcedure {
    public static int LOCAL_CHAT_RADIUS = 50;
    public static String GLOBAL_PREFIX = "!";
    public static String GLOBAL_FORMAT = "\u00a7l\u00a7a[G] \u00a7r<{player}> {message}";
    public static String LOCAL_FORMAT = "\u00a7l\u00a7e[L] \u00a7r<{player}> {message}";
    public static String NO_ONE_SAW_MESSAGE = "\u00a7l\u00a7e\u0412\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0438\u043a\u0442\u043e \u043d\u0435 \u0443\u0432\u0438\u0434\u0435\u043b.";

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ConfigProcedure.loadConfig();
    }

    private static void loadConfig() {
        Path configPath = FMLPaths.GAMEDIR.get().resolve("config/chat_plus-config.txt");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                ConfigProcedure.createDefaultConfig(configPath, gson);
            }
            String json = Files.readString(configPath);
            JsonObject config = JsonParser.parseString((String)json).getAsJsonObject();
            LOCAL_CHAT_RADIUS = config.get("local_chat_radius").getAsInt();
            GLOBAL_PREFIX = config.get("global_prefix").getAsString();
            JsonObject messageFormats = config.getAsJsonObject("message_formats");
            GLOBAL_FORMAT = messageFormats.get("global").getAsString();
            LOCAL_FORMAT = messageFormats.get("local").getAsString();
            NO_ONE_SAW_MESSAGE = config.get("no_one_saw_message").getAsString();
        }
        catch (Exception e) {
            System.err.println("Error loading config: " + e.getMessage());
            ConfigProcedure.createDefaultConfig(configPath, gson);
        }
    }

    private static void createDefaultConfig(Path configPath, Gson gson) {
        try {
            JsonObject root = new JsonObject();
            root.addProperty("local_chat_radius", (Number)50);
            root.addProperty("global_prefix", "!");
            root.addProperty("no_one_saw_message", "\u00a7l\u00a7e\u0412\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0438\u043a\u0442\u043e \u043d\u0435 \u0443\u0432\u0438\u0434\u0435\u043b.");
            JsonObject messageFormats = new JsonObject();
            messageFormats.addProperty("global", "\u00a7l\u00a7a[G] \u00a7r<{player}> {message}");
            messageFormats.addProperty("local", "\u00a7l\u00a7e[L] \u00a7r<{player}> {message}");
            root.add("message_formats", (JsonElement)messageFormats);
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Files.writeString(configPath, (CharSequence)gson.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create config: " + e.getMessage());
        }
    }
}

