package io.github.gameking1happy.gk1haccessorifyplus.mixin.netheriteextras;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import me.pajic.accessorify.Main;
import me.pajic.accessorify.util.ModUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import xyz.hafemann.netheriteextras.event.ModEvents;
import xyz.hafemann.netheriteextras.item.ModItems;

/**
 * Makes the Totem of Neverdying actually work.
 */
@IfModLoaded("netheriteextras")
@Mixin(ModEvents.class)
public class ModEventsMixin {

    @ModifyExpressionValue(
            method = "lambda$registerModEvents$1",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private static ItemStack tryConsumeTotemAccessory(ItemStack original, LivingEntity livingEntity) {
        if (Main.CONFIG.accessorySettings.totemOfUndyingAccessory.get()) {
            ItemStack itemStack = ModUtil.getAccessoryStack(livingEntity, ModItems.TOTEM_OF_NEVERDYING).right();
            return itemStack.isEmpty() ? original : itemStack;
        }
        return original;
    }
}