/*
 * Decompiled with CFR 0.152.
 */
package com.tyurvib.transactions;

import com.djrapitops.vaultevents.events.economy.PlayerDepositEvent;
import com.djrapitops.vaultevents.events.economy.PlayerWithdrawEvent;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tyurvib.transactions.Updater;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class Transactions
extends JavaPlugin
implements Listener,
TabExecutor {
    private static final String SELECTED_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTIxOTI4ZWE2N2QzYThiOTdkMjEyNzU4ZjE1Y2NjYWMxMDI0Mjk1YjE4NWIzMTkyNjQ4NDRmNGM1ZTFlNjFlIn19fQ==";
    private static final String UNSELECTED_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjVlZjY4ZGNiZDU4MjM0YmE3YWVlMmFkOTFjYTZmYTdjZTIzZjlhMzIzNDViNDhkNmU1ZjViODZhNjhiNWIifX19";
    private static final String SEARCH_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjc0OGYyMTM1ODhkYmY0NDE1Y2UyNGZlNjZkZTM1MjY4MTZiZjM1ZGY4ZTM5OGY5OGVmZWMyZmIwODk1NmEzIn19fQ==";
    Map<UUID, List<Transaction>> transactions = new HashMap<UUID, List<Transaction>>();
    private long saveIntervalTicks;
    private int saveTaskId;
    private final Set<UUID> dirtyPlayers = new HashSet<UUID>();
    Map<UUID, Integer> currentPage = new HashMap<UUID, Integer>();
    Map<UUID, Integer> playerGmtOffset = new HashMap<UUID, Integer>();
    Map<UUID, FilterData> playerFilters = new HashMap<UUID, FilterData>();
    Map<UUID, Boolean> showBalance = new HashMap<UUID, Boolean>();
    File dataFolder;
    private DecimalFormat amountFormatter;
    private Economy economy;
    private int defaultGmtOffset;
    private String prefix;
    private int taskId;
    private String incomeMessageColor;
    private String incomeAmountColor;
    private String expenseMessageColor;
    private String expenseAmountColor;
    private String yellowMessageColor;
    private String yellowAmountColor;
    private boolean showStatsButton;
    private boolean allowBalanceToggle;
    private long cleanTransactionsPeriodMs;
    private final Set<UUID> payProcessingPlayers = new HashSet<UUID>();
    private Map<String, String> translations;
    private Updater updater;
    private String modrinthProjectId = "GbElTVjA";
    private final Set<UUID> playerInSearchMode = new HashSet<UUID>();
    private final Map<UUID, String> searchTargetPlayer = new HashMap<UUID, String>();
    private final Map<UUID, Transaction> pendingRollback = new HashMap<UUID, Transaction>();
    private final Map<UUID, UUID> rollbackTargetUUID = new HashMap<UUID, UUID>();
    private final Map<UUID, String> rollbackTargetName = new HashMap<UUID, String>();
    private final Set<UUID> pendingClean = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveResource("lang/ru.yml", false);
        this.saveResource("lang/en.yml", false);
        this.saveResource("lang/de.yml", false);
        this.saveResource("lang/zh.yml", false);
        this.saveResource("lang/tr.yml", false);
        this.saveResource("lang/sv.yml", false);
        this.saveResource("lang/pt.yml", false);
        this.saveResource("lang/pl.yml", false);
        this.saveResource("lang/ko.yml", false);
        this.saveResource("lang/ja.yml", false);
        this.saveResource("lang/it.yml", false);
        this.saveResource("lang/fr.yml", false);
        this.saveResource("lang/es.yml", false);
        this.updater = new Updater(this, this.modrinthProjectId);
        this.updater.checkForUpdates();
        this.loadConfigValues();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("transactions").setExecutor((CommandExecutor)this);
        if (!this.setupEconomy()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.dataFolder = new File(this.getDataFolder(), "data");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        this.loadAll();
        this.amountFormatter = new DecimalFormat("#,##0.##");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setGroupingSeparator(' ');
        this.amountFormatter.setDecimalFormatSymbols(symbols);
        this.taskId = Bukkit.getScheduler().runTaskTimer((Plugin)this, this::clearAllTransactions, this.cleanTransactionsPeriodMs / 50L, this.cleanTransactionsPeriodMs / 50L).getTaskId();
        this.saveTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::saveAll, this.saveIntervalTicks, this.saveIntervalTicks).getTaskId();
    }

    void clearAllTransactions() {
        this.transactions.clear();
        File[] files = this.dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
        this.dirtyPlayers.clear();
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.saveTaskId);
        this.saveAll();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().isOp() && this.updater.isUpdateAvailable()) {
            String downloadUrl = "https://modrinth.com/plugin/" + this.modrinthProjectId + "/versions";
            event.getPlayer().sendMessage(this.getTranslation("update-available", event.getPlayer().getName(), this.updater.getLatestVersion(), downloadUrl));
        }
    }

    private long parseTimePeriod(String period) {
        try {
            String unit;
            Pattern pattern = Pattern.compile("^(\\d+)([smhdw]|mo|y)$");
            Matcher matcher = pattern.matcher(period.toLowerCase());
            if (!matcher.matches()) {
                return TimeUnit.DAYS.toMillis(14L);
            }
            long value = Long.parseLong(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "s": {
                    return TimeUnit.SECONDS.toMillis(value);
                }
                case "m": {
                    return TimeUnit.MINUTES.toMillis(value);
                }
                case "h": {
                    return TimeUnit.HOURS.toMillis(value);
                }
                case "d": {
                    return TimeUnit.DAYS.toMillis(value);
                }
                case "w": {
                    return TimeUnit.DAYS.toMillis(value * 7L);
                }
                case "mo": {
                    return TimeUnit.DAYS.toMillis(value * 30L);
                }
                case "y": {
                    return TimeUnit.DAYS.toMillis(value * 365L);
                }
            }
            return TimeUnit.DAYS.toMillis(14L);
        }
        catch (NumberFormatException e) {
            return TimeUnit.DAYS.toMillis(14L);
        }
    }

    private void loadConfigValues() {
        this.reloadConfig();
        this.prefix = this.getConfig().getString("prefix", "\ud83d\udcb0");
        this.showStatsButton = this.getConfig().getBoolean("show-stats-button", true);
        this.allowBalanceToggle = this.getConfig().getBoolean("allow-balance-toggle", true);
        this.incomeMessageColor = this.getConfig().getString("income-message-color", "\u00a7f");
        this.incomeAmountColor = this.getConfig().getString("income-amount-color", "\u00a7a");
        this.expenseMessageColor = this.getConfig().getString("expense-message-color", "\u00a7f");
        this.expenseAmountColor = this.getConfig().getString("expense-amount-color", "\u00a7c");
        this.yellowMessageColor = this.getConfig().getString("yellow-message-color", "\u00a7f");
        this.yellowAmountColor = this.getConfig().getString("yellow-amount-color", "\u00a7e");
        this.cleanTransactionsPeriodMs = this.parseTimePeriod(this.getConfig().getString("clean-transactions-period", "14d"));
        this.defaultGmtOffset = this.getConfig().getInt("default-gmt-offset", 0);
        if (!this.allowBalanceToggle) {
            for (UUID uuid : this.showBalance.keySet()) {
                this.showBalance.put(uuid, false);
            }
        }
        long saveIntervalSeconds = this.getConfig().getLong("save-interval-seconds", 60L);
        this.saveIntervalTicks = saveIntervalSeconds * 20L;
        String language = this.getConfig().getString("language", "en");
        File langFile = new File(String.valueOf(this.getDataFolder()) + "/lang", language + ".yml");
        if (!langFile.exists()) {
            langFile = new File(String.valueOf(this.getDataFolder()) + "/lang", "en.yml");
        }
        YamlConfiguration langConfig = YamlConfiguration.loadConfiguration((File)langFile);
        this.translations = new HashMap<String, String>();
        for (String key : langConfig.getKeys(false)) {
            this.translations.put(key, langConfig.getString(key));
        }
    }

    private String getTranslation(String key, String ... placeholders) {
        String translated = this.translations.getOrDefault(key, key);
        for (int i = 0; i < placeholders.length; ++i) {
            translated = translated.replace("%p" + (i + 1) + "%", placeholders[i]);
        }
        return translated;
    }

    private String stripColor(String text) {
        return ChatColor.stripColor((String)text);
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    void addTransaction(UUID uuid, Transaction t) {
        if (t.amount > 0.0) {
            this.transactions.computeIfAbsent(uuid, k -> new ArrayList()).add(0, t);
            this.dirtyPlayers.add(uuid);
        }
    }

    List<Transaction> getTransactions(UUID uuid) {
        return this.transactions.getOrDefault(uuid, new ArrayList());
    }

    public static ItemStack getHead(String base64) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)Objects.requireNonNull(item.getItemMeta());
        try {
            String skinJson = new String(Base64.getDecoder().decode(base64));
            JsonObject skinObject = JsonParser.parseString((String)skinJson).getAsJsonObject();
            String url = skinObject.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
            PlayerTextures textures = profile.getTextures();
            URL urlObject = new URL(url);
            textures.setSkin(urlObject);
            profile.setTextures(textures);
            skullMeta.setOwnerProfile(profile);
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return item;
        }
        item.setItemMeta((ItemMeta)skullMeta);
        return item;
    }

    private String getTranslatedDescription(Transaction t) {
        String messageColor;
        String translated = this.translations.getOrDefault(t.key, t.key);
        for (int i = 0; i < t.params.length; ++i) {
            translated = translated.replace("%p" + (i + 1) + "%", t.params[i]);
        }
        String amountColor = switch (t.type.ordinal()) {
            case 0 -> {
                messageColor = this.incomeMessageColor;
                yield this.incomeAmountColor;
            }
            case 1 -> {
                messageColor = this.expenseMessageColor;
                yield this.expenseAmountColor;
            }
            case 2 -> {
                messageColor = this.yellowMessageColor;
                yield this.yellowAmountColor;
            }
            default -> {
                messageColor = "\u00a7f";
                yield "\u00a7a";
            }
        };
        String formattedAmount = "(" + (t.type == Type.INCOME ? "+" : (t.type == Type.EXPENSE ? "-" : "")) + this.amountFormatter.format(t.amount) + " " + this.prefix + ")";
        return messageColor + translated + " " + amountColor + formattedAmount;
    }

    void openGUI(Player player, int page, UUID targetUUID, String targetName) {
        FilterData filter = this.playerFilters.computeIfAbsent(player.getUniqueId(), k -> new FilterData());
        List<Transaction> list = this.getTransactions(targetUUID);
        ArrayList<Transaction> filteredList = new ArrayList<Transaction>();
        long cutoffTimestamp = 0L;
        if (filter.timePeriod == TimePeriod.LAST_7_DAYS) {
            cutoffTimestamp = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(7L);
        } else if (filter.timePeriod == TimePeriod.LAST_30_DAYS) {
            cutoffTimestamp = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(30L);
        }
        for (Transaction t : list) {
            if (filter.timePeriod != TimePeriod.ALL_TIME && t.timestamp < cutoffTimestamp || filter.filterType != FilterType.ALL && (filter.filterType != FilterType.INCOME || t.type != Type.INCOME) && (filter.filterType != FilterType.EXPENSE || t.type != Type.EXPENSE)) continue;
            filteredList.add(t);
        }
        filteredList.sort((t1, t2) -> Long.compare(t2.timestamp, t1.timestamp));
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(this.getTranslation("gui-title", new String[0]) + targetName + " (#" + (page + 1) + ")"));
        int transactionsPerPage = 45;
        int start = page * transactionsPerPage;
        int end = Math.min(filteredList.size(), start + transactionsPerPage);
        int gmtOffset = this.playerGmtOffset.getOrDefault(player.getUniqueId(), this.defaultGmtOffset);
        double currentBalance = this.economy.getBalance(Bukkit.getOfflinePlayer((UUID)targetUUID));
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT" + (gmtOffset >= 0 ? "+" : "") + gmtOffset));
        for (int i = start; i < end; ++i) {
            Transaction t = (Transaction)filteredList.get(i);
            String base64 = this.getTransactionHeadBase64(t.type);
            ItemStack item = Transactions.getHead(base64);
            ItemMeta meta = item.getItemMeta();
            String colorCode = this.getTransactionColor(t.type);
            meta.setDisplayName(colorCode + this.getTranslatedDescription(t));
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            if (this.showBalance.getOrDefault(player.getUniqueId(), true).booleanValue() && t.type != Type.YELLOW) {
                double balanceAtTransaction = currentBalance;
                for (int j = 0; j < i; ++j) {
                    Transaction newer = (Transaction)filteredList.get(j);
                    balanceAtTransaction += newer.type == Type.INCOME ? -newer.amount : (newer.type == Type.EXPENSE ? newer.amount : 0.0);
                }
                double previousBalance = balanceAtTransaction + (t.type == Type.INCOME ? -t.amount : t.amount);
                lore.add((CallSite)((Object)(colorCode + this.getTranslation("balance-change", this.amountFormatter.format(Math.abs(previousBalance)), this.amountFormatter.format(Math.abs(balanceAtTransaction))))));
            }
            lore.add((CallSite)((Object)(this.getTranslation("time", new String[0]) + sdf.format(new Date(t.timestamp)))));
            if (player.hasPermission("transactions.rollback") && t.key.equals("transaction-pay-received") && !t.rolledBack) {
                lore.add((CallSite)((Object)("\u00a7e" + this.getTranslation("rollback-hint", new String[0]))));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            inv.setItem(i - start, item);
        }
        ItemStack emptySlotFiller = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta emptyMeta = emptySlotFiller.getItemMeta();
        emptyMeta.setDisplayName(" ");
        emptySlotFiller.setItemMeta(emptyMeta);
        for (int i = end - start; i < transactionsPerPage; ++i) {
            inv.setItem(i, emptySlotFiller);
        }
        if (page > 0) {
            inv.setItem(45, this.createButton(Material.ARROW, this.getTranslation("prev-button", new String[0])));
        }
        if (end < filteredList.size()) {
            inv.setItem(53, this.createButton(Material.ARROW, this.getTranslation("next-button", new String[0])));
        }
        ItemStack filterButton = Transactions.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGNlZTNhZWFkZDY4YjI0N2ZkZmUzZWE3YmMwMDhkMTJmZDk3YWMxNWVkMTViZjc0Njg1NDNhMDY2ODAifX19");
        ItemMeta filterMeta = filterButton.getItemMeta();
        filterMeta.setDisplayName(this.getTranslation("filter-button", new String[0]));
        filterMeta.setLore(Collections.singletonList(this.getTranslation("filter-current-type", new String[0]) + this.getTranslation("filter-type-" + filter.filterType.name().toLowerCase(), new String[0])));
        filterButton.setItemMeta(filterMeta);
        inv.setItem(48, filterButton);
        if (this.showStatsButton) {
            ItemStack statsButton = Transactions.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2QyNGRjNTgwNjljMTIxMmI1MjlhNGFlNWQ0ZTczYmUwOTkwZDQ2ZmU5MzcxYjFmNzllODE2NGI0Mjg1OWFjOCJ9fX0=");
            ItemMeta statsMeta = statsButton.getItemMeta();
            statsMeta.setDisplayName(this.getTranslation("stats-button", new String[0]));
            ArrayList<Object> statsLore = new ArrayList<Object>();
            double income = 0.0;
            double expense = 0.0;
            long cutoff = System.currentTimeMillis() - this.cleanTransactionsPeriodMs;
            for (Transaction t : list) {
                if (t.timestamp < cutoff) continue;
                if (t.type == Type.INCOME) {
                    income += t.amount;
                    continue;
                }
                if (t.type != Type.EXPENSE) continue;
                expense += t.amount;
            }
            if (income >= expense) {
                statsLore.add(income > 0.0 ? this.getTranslation("stats-income", new String[0]) + this.amountFormatter.format(income) + " " + this.prefix : this.getTranslation("stats-no-income", new String[0]));
                statsLore.add(expense > 0.0 ? this.getTranslation("stats-expense", new String[0]) + this.amountFormatter.format(expense) + " " + this.prefix : this.getTranslation("stats-no-expense", new String[0]));
            } else {
                statsLore.add(expense > 0.0 ? this.getTranslation("stats-expense", new String[0]) + this.amountFormatter.format(expense) + " " + this.prefix : this.getTranslation("stats-no-expense", new String[0]));
                statsLore.add(income > 0.0 ? this.getTranslation("stats-income", new String[0]) + this.amountFormatter.format(income) + " " + this.prefix : this.getTranslation("stats-no-income", new String[0]));
            }
            statsMeta.setLore(statsLore);
            statsButton.setItemMeta(statsMeta);
            inv.setItem(49, statsButton);
            ItemStack searchButton = player.getUniqueId().equals(targetUUID) || player.hasPermission("transactions.view.others") ? this.createHeadButton(SEARCH_HEAD, String.valueOf(ChatColor.BLUE) + String.valueOf(ChatColor.RESET) + this.getTranslation("search-button", new String[0])) : this.createButton(Material.BARRIER, String.valueOf(ChatColor.RED) + this.getTranslation("search-disabled", new String[0]));
            inv.setItem(50, searchButton);
        }
        this.currentPage.put(player.getUniqueId(), page);
        this.searchTargetPlayer.put(player.getUniqueId(), targetName);
        player.openInventory(inv);
    }

    void openGUI(Player player, int page) {
        this.openGUI(player, page, player.getUniqueId(), player.getName());
    }

    void openGUI(Player player, int page, FilterData filter) {
        this.playerFilters.put(player.getUniqueId(), filter);
        this.openGUI(player, page, player.getUniqueId(), player.getName());
    }

    void openFilterGUI(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)this.getTranslation("filter-gui-title", new String[0]));
        FilterData currentFilter = this.playerFilters.computeIfAbsent(player.getUniqueId(), k -> new FilterData());
        String filterAllHead = currentFilter.filterType == FilterType.ALL ? SELECTED_HEAD : UNSELECTED_HEAD;
        String filterIncomeHead = currentFilter.filterType == FilterType.INCOME ? SELECTED_HEAD : UNSELECTED_HEAD;
        String filterExpenseHead = currentFilter.filterType == FilterType.EXPENSE ? SELECTED_HEAD : UNSELECTED_HEAD;
        ItemStack filterAll = this.createHeadButton(filterAllHead, this.getTranslation("filter-type-all", new String[0]));
        ItemStack filterIncome = this.createHeadButton(filterIncomeHead, this.getTranslation("filter-type-income", new String[0]));
        ItemStack filterExpense = this.createHeadButton(filterExpenseHead, this.getTranslation("filter-type-expense", new String[0]));
        String timeAllHead = currentFilter.timePeriod == TimePeriod.ALL_TIME ? SELECTED_HEAD : UNSELECTED_HEAD;
        String time7daysHead = currentFilter.timePeriod == TimePeriod.LAST_7_DAYS ? SELECTED_HEAD : UNSELECTED_HEAD;
        String time30daysHead = currentFilter.timePeriod == TimePeriod.LAST_30_DAYS ? SELECTED_HEAD : UNSELECTED_HEAD;
        inv.setItem(3, filterAll);
        inv.setItem(4, filterIncome);
        inv.setItem(5, filterExpense);
        inv.setItem(8, this.createButton(Material.ARROW, this.getTranslation("back-button", new String[0])));
        player.openInventory(inv);
    }

    ItemStack createButton(Material mat, String name) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    ItemStack createHeadButton(String base64, String name) {
        ItemStack item = Transactions.getHead(base64);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    void openSearchResultsGUI(Player player, List<Transaction> searchResults, String searchName, int page) {
        int i;
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(this.getTranslation("search-results-gui-title", new String[0]) + " " + searchName));
        int transactionsPerPage = 45;
        int start = page * transactionsPerPage;
        int end = Math.min(searchResults.size(), start + transactionsPerPage);
        int gmtOffset = this.playerGmtOffset.getOrDefault(player.getUniqueId(), this.defaultGmtOffset);
        UUID targetUUID = this.rollbackTargetUUID.getOrDefault(player.getUniqueId(), player.getUniqueId());
        double currentBalance = this.economy.getBalance(Bukkit.getOfflinePlayer((UUID)targetUUID));
        List sortedSearchResults = searchResults.stream().sorted((t1, t2) -> Long.compare(t2.timestamp, t1.timestamp)).collect(Collectors.toList());
        for (i = start; i < end; ++i) {
            Transaction t = (Transaction)sortedSearchResults.get(i);
            ItemStack item = Transactions.getHead(switch (t.type.ordinal()) {
                case 0 -> "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDY3ZGNlNDY0NTM0OWU0MWE3ZjM1Nzk3ZTJiOTI3OWUzNWE2NWY1ZTgxYTM0NDk2ODg1ZDI3MjY4ZjM2OTEzOSJ9fX0=";
                case 1 -> "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGQxMTEwOWY0YWIwM2FhNmM1Yjc2Y2FkMTI5MTc2ZmZiMWZjZThjMTc0ZTY5YzllOGJhMDZiOWY4MDYxZTVhZCJ9fX0=";
                case 2 -> "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTQ2N2E3YjlkNzZiYTZkMGZlZDc0MzYwMjUzM2ZjOThjODdhZjBjNjBmODBmMzhkYTc3NGY3YTAxYTIwOTNmYSJ9fX0=";
                default -> "";
            });
            ItemMeta meta = item.getItemMeta();
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            String gmtString = "GMT" + (gmtOffset >= 0 ? "+" : "") + gmtOffset;
            sdf.setTimeZone(TimeZone.getTimeZone(gmtString));
            String colorCode = t.type == Type.INCOME ? this.incomeMessageColor : (t.type == Type.EXPENSE ? this.expenseMessageColor : this.yellowMessageColor);
            meta.setDisplayName(colorCode + this.getTranslatedDescription(t));
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            if (this.showBalance.getOrDefault(player.getUniqueId(), true).booleanValue() && t.type != Type.YELLOW) {
                double balanceAtTransaction = currentBalance;
                for (int j = 0; j < i; ++j) {
                    Transaction newer = (Transaction)sortedSearchResults.get(j);
                    if (newer.type == Type.INCOME) {
                        balanceAtTransaction -= newer.amount;
                        continue;
                    }
                    if (newer.type != Type.EXPENSE) continue;
                    balanceAtTransaction += newer.amount;
                }
                double previousBalance = balanceAtTransaction + (t.type == Type.INCOME ? -t.amount : t.amount);
                String balanceChange = this.getTranslation("balance-change", this.amountFormatter.format(Math.abs(previousBalance)), this.amountFormatter.format(Math.abs(balanceAtTransaction)));
                lore.add((CallSite)((Object)(colorCode + balanceChange)));
            }
            lore.add((CallSite)((Object)(this.getTranslation("time", new String[0]) + sdf.format(new Date(t.timestamp)))));
            meta.setLore(lore);
            item.setItemMeta(meta);
            inv.setItem(i - start, item);
        }
        for (i = end - start; i < transactionsPerPage; ++i) {
            ItemStack emptySlotFiller = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemMeta meta = emptySlotFiller.getItemMeta();
            meta.setDisplayName(" ");
            emptySlotFiller.setItemMeta(meta);
            inv.setItem(i, emptySlotFiller);
        }
        if (page > 0) {
            inv.setItem(45, this.createButton(Material.ARROW, this.getTranslation("prev-button", new String[0])));
        }
        if (end < sortedSearchResults.size()) {
            inv.setItem(53, this.createButton(Material.ARROW, this.getTranslation("next-button", new String[0])));
        }
        inv.setItem(49, this.createButton(Material.BARRIER, this.getTranslation("back-button", new String[0])));
        this.currentPage.put(player.getUniqueId(), page);
        player.openInventory(inv);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        if (!this.playerInSearchMode.contains(p.getUniqueId())) {
            return;
        }
        e.setCancelled(true);
        String searchName = e.getMessage().trim();
        this.playerInSearchMode.remove(p.getUniqueId());
        String targetName = this.searchTargetPlayer.getOrDefault(p.getUniqueId(), p.getName());
        UUID targetUUID = this.rollbackTargetUUID.getOrDefault(p.getUniqueId(), p.getUniqueId());
        if (searchName.equalsIgnoreCase(targetName)) {
            p.sendMessage("\u00a7c" + this.getTranslation("cannot-search-self", new String[0]));
            this.openGUI(p, 0, targetUUID, targetName);
            return;
        }
        List<Transaction> allTransactions = this.getTransactions(targetUUID);
        ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
        block0: for (Transaction t : allTransactions) {
            for (String param : t.params) {
                if (!param.equalsIgnoreCase(searchName)) continue;
                filteredTransactions.add(t);
                continue block0;
            }
        }
        if (filteredTransactions.isEmpty()) {
            p.sendMessage("\u00a7c" + this.getTranslation("no-transactions-found", searchName));
            this.openGUI(p, 0, targetUUID, targetName);
            return;
        }
        this.searchTargetPlayer.put(p.getUniqueId(), searchName);
        this.currentPage.put(p.getUniqueId(), 0);
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.openSearchResultsGUI(p, filteredTransactions, searchName, 0));
    }

    private void openRollbackConfirmationGUI(Player player, Transaction transaction, UUID targetUUID, String targetName) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)this.getTranslation("rollback-confirm-title", new String[0]));
        String confirmBase64 = SELECTED_HEAD;
        String cancelBase64 = UNSELECTED_HEAD;
        ItemStack confirmButton = Transactions.getHead(confirmBase64);
        ItemMeta confirmMeta = confirmButton.getItemMeta();
        confirmMeta.setDisplayName(this.getTranslation("confirm-rollback", new String[0]));
        confirmButton.setItemMeta(confirmMeta);
        ItemStack cancelButton = Transactions.getHead(cancelBase64);
        ItemMeta cancelMeta = cancelButton.getItemMeta();
        cancelMeta.setDisplayName(this.getTranslation("cancel-rollback", new String[0]));
        cancelButton.setItemMeta(cancelMeta);
        ItemStack infoItem = Transactions.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDY3ZGNlNDY0NTM0OWU0MWE3ZjM1Nzk3ZTJiOTI3OWUzNWE2NWY1ZTgxYTM0NDk2ODg1ZDI3MjY4ZjM2OTEzOSJ9fX0=");
        ItemMeta infoMeta = infoItem.getItemMeta();
        infoMeta.setDisplayName("\u00a7e" + this.getTranslatedDescription(transaction));
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)("\u00a77" + this.getTranslation("rollback-amount", this.amountFormatter.format(transaction.amount)))));
        lore.add((CallSite)((Object)("\u00a77" + this.getTranslation("rollback-receiver", targetName))));
        lore.add((CallSite)((Object)("\u00a77" + this.getTranslation("rollback-sender", transaction.params[0]))));
        infoMeta.setLore(lore);
        infoItem.setItemMeta(infoMeta);
        inv.setItem(11, confirmButton);
        inv.setItem(13, infoItem);
        inv.setItem(15, cancelButton);
        this.pendingRollback.put(player.getUniqueId(), transaction);
        this.rollbackTargetUUID.put(player.getUniqueId(), targetUUID);
        this.rollbackTargetName.put(player.getUniqueId(), targetName);
        player.openInventory(inv);
    }

    private String getTransactionHeadBase64(Type type) {
        switch (type.ordinal()) {
            case 0: {
                return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDY3ZGNlNDY0NTM0OWU0MWE3ZjM1Nzk3ZTJiOTI3OWUzNWE2NWY1ZTgxYTM0NDk2ODg1ZDI3MjY4ZjM2OTEzOSJ9fX0=";
            }
            case 1: {
                return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGQxMTEwOWY0YWIwM2FhNmM1Yjc2Y2FkMTI5MTc2ZmZiMWZjZThjMTc0ZTY5YzllOGJhMDZiOWY4MDYxZTVhZCJ9fX0=";
            }
            case 2: {
                return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTQ2N2E3YjlkNzZiYTZkMGZlZDc0MzYwMjUzM2ZjOThjODdhZjBjNjBmODBmMzhkYTc3NGY3YTAxYTIwOTNmYSJ9fX0=";
            }
        }
        return "";
    }

    private String getTransactionColor(Type type) {
        switch (type.ordinal()) {
            case 0: {
                return this.incomeMessageColor;
            }
            case 1: {
                return this.expenseMessageColor;
            }
            case 2: {
                return this.yellowMessageColor;
            }
        }
        return "\u00a7f";
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = e.getView().getTitle();
        String guiTitle = this.getTranslation("gui-title", new String[0]).substring(0, this.getTranslation("gui-title", new String[0]).length() - 1);
        ItemStack item = e.getCurrentItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        String name = this.stripColor(item.getItemMeta().getDisplayName());
        int page = this.currentPage.getOrDefault(player.getUniqueId(), 0);
        String targetName = this.searchTargetPlayer.getOrDefault(player.getUniqueId(), player.getName());
        UUID targetUUID = Bukkit.getOfflinePlayer((String)targetName).getUniqueId();
        if (title.startsWith(guiTitle)) {
            String url;
            SkullMeta skullMeta;
            e.setCancelled(true);
            if (e.getClick() == ClickType.RIGHT && player.hasPermission("transactions.rollback") && item.getType() == Material.PLAYER_HEAD && (skullMeta = (SkullMeta)item.getItemMeta()).getOwnerProfile() != null && skullMeta.getOwnerProfile().getTextures() != null && ((url = skullMeta.getOwnerProfile().getTextures().getSkin().toString()).contains("d67dce4645349e41a7f35797e2b9279e35a65f5e81a34496885d27268f369139") || url.contains("4d11109f4ab03aa6c5b76cad129176ffb1fce8c174e69c9e8ba06b9f8061e5ad"))) {
                List<Transaction> transactionsList = this.getTransactions(targetUUID);
                int index = page * 45 + e.getSlot();
                if (index < transactionsList.size()) {
                    Transaction t2 = transactionsList.get(index);
                    if (t2.key.equals("transaction-pay-received") && !t2.rolledBack) {
                        this.openRollbackConfirmationGUI(player, t2, targetUUID, targetName);
                        return;
                    }
                }
            }
            if (item.getType() == Material.PLAYER_HEAD && (skullMeta = (SkullMeta)item.getItemMeta()).getOwnerProfile() != null && skullMeta.getOwnerProfile().getTextures() != null) {
                url = skullMeta.getOwnerProfile().getTextures().getSkin().toString();
                if (url.contains("dcee3aea")) {
                    this.openFilterGUI(player);
                    return;
                }
                if (url.contains("f748f213588dbf4415ce24fe66de3526816bf35df8e398f98efec2fb08956a3")) {
                    player.closeInventory();
                    player.sendTitle("\u00a76" + this.getTranslation("enter-player-in-chat", new String[0]), "", 10, 70, 20);
                    this.playerInSearchMode.add(player.getUniqueId());
                    this.searchTargetPlayer.put(player.getUniqueId(), targetName);
                    this.rollbackTargetUUID.put(player.getUniqueId(), targetUUID);
                    return;
                }
            }
            if (name.equals(this.stripColor(this.getTranslation("prev-button", new String[0])))) {
                this.openGUI(player, page - 1, targetUUID, targetName);
            } else if (name.equals(this.stripColor(this.getTranslation("next-button", new String[0])))) {
                this.openGUI(player, page + 1, targetUUID, targetName);
            }
        } else if (title.equals(this.getTranslation("filter-gui-title", new String[0]))) {
            e.setCancelled(true);
            if (item == null || !item.hasItemMeta()) {
                return;
            }
            FilterData filter = this.playerFilters.computeIfAbsent(player.getUniqueId(), k -> new FilterData());
            String strippedName = this.stripColor(item.getItemMeta().getDisplayName());
            if (strippedName.equals(this.stripColor(this.getTranslation("filter-type-all", new String[0])))) {
                filter.filterType = FilterType.ALL;
            } else if (strippedName.equals(this.stripColor(this.getTranslation("filter-type-income", new String[0])))) {
                filter.filterType = FilterType.INCOME;
            } else if (strippedName.equals(this.stripColor(this.getTranslation("filter-type-expense", new String[0])))) {
                filter.filterType = FilterType.EXPENSE;
            } else if (strippedName.equals(this.stripColor(this.getTranslation("back-button", new String[0])))) {
                if (targetName == null || targetUUID == null) {
                    targetName = player.getName();
                    targetUUID = player.getUniqueId();
                }
                this.openGUI(player, page, targetUUID, targetName);
                return;
            }
            this.playerFilters.put(player.getUniqueId(), filter);
            if (targetName == null || targetUUID == null) {
                targetName = player.getName();
                targetUUID = player.getUniqueId();
            }
            this.openGUI(player, page, targetUUID, targetName);
        } else if (title.equals(this.getTranslation("rollback-confirm-title", new String[0]))) {
            e.setCancelled(true);
            if (name.equals(this.stripColor(this.getTranslation("confirm-rollback", new String[0])))) {
                Transaction transaction = this.pendingRollback.get(player.getUniqueId());
                if (transaction != null) {
                    this.rollbackTransaction(player, transaction, targetUUID, targetName);
                    this.pendingRollback.remove(player.getUniqueId());
                    this.rollbackTargetUUID.remove(player.getUniqueId());
                    this.rollbackTargetName.remove(player.getUniqueId());
                    player.closeInventory();
                }
            } else if (name.equals(this.stripColor(this.getTranslation("cancel-rollback", new String[0])))) {
                this.pendingRollback.remove(player.getUniqueId());
                this.rollbackTargetUUID.remove(player.getUniqueId());
                this.rollbackTargetName.remove(player.getUniqueId());
                player.closeInventory();
                this.openGUI(player, page, targetUUID, targetName);
            }
        } else if (title.startsWith(this.getTranslation("search-results-gui-title", new String[0]))) {
            e.setCancelled(true);
            String finalTargetName = targetName;
            List<Transaction> searchResults = this.getTransactions(targetUUID).stream().filter(t -> Arrays.stream(t.params).anyMatch(param -> param.equalsIgnoreCase(finalTargetName))).collect(Collectors.toList());
            if (name.equals(this.stripColor(this.getTranslation("prev-button", new String[0])))) {
                if (page > 0) {
                    this.openSearchResultsGUI(player, searchResults, finalTargetName, page - 1);
                }
            } else if (name.equals(this.stripColor(this.getTranslation("next-button", new String[0])))) {
                this.openSearchResultsGUI(player, searchResults, finalTargetName, page + 1);
            } else if (name.equals(this.stripColor(this.getTranslation("back-button", new String[0])))) {
                this.openGUI(player, page, targetUUID, finalTargetName);
            }
        }
    }

    private void rollbackTransaction(Player admin, Transaction transaction, UUID targetUUID, String targetName) {
        double amount;
        if (!transaction.key.equals("transaction-pay-received")) {
            admin.sendMessage("\u00a7c" + this.getTranslation("rollback-invalid-transaction", new String[0]));
            return;
        }
        String senderName = transaction.params[0];
        OfflinePlayer sender = Bukkit.getOfflinePlayer((String)senderName);
        OfflinePlayer receiver = Bukkit.getOfflinePlayer((String)targetName);
        if (!this.economy.has(receiver, amount = transaction.amount)) {
            admin.sendMessage("\u00a7c" + this.getTranslation("rollback-insufficient-funds", targetName));
            return;
        }
        this.economy.withdrawPlayer(receiver, amount);
        this.economy.depositPlayer(sender, amount);
        this.addTransaction(receiver.getUniqueId(), new Transaction(Type.EXPENSE, "transaction-rollback", amount, senderName));
        this.addTransaction(sender.getUniqueId(), new Transaction(Type.INCOME, "transaction-rollback-received", amount, targetName));
        this.dirtyPlayers.add(receiver.getUniqueId());
        this.dirtyPlayers.add(sender.getUniqueId());
        admin.sendMessage("\u00a7a" + this.getTranslation("rollback-success", targetName, this.amountFormatter.format(amount), senderName));
        if (receiver.isOnline()) {
            receiver.getPlayer().sendMessage("\u00a7c" + this.getTranslation("rollback-notify-receiver", this.amountFormatter.format(amount), senderName));
        }
        if (sender.isOnline()) {
            sender.getPlayer().sendMessage("\u00a7a" + this.getTranslation("rollback-notify-sender", this.amountFormatter.format(amount), targetName));
        }
        this.openGUI(admin, this.currentPage.getOrDefault(admin.getUniqueId(), 0), targetUUID, targetName);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (e.isCancelled()) {
            return;
        }
        String msg = e.getMessage().substring(1);
        String[] args = msg.split(" ");
        this.handleCommand(e.getPlayer().getName(), args, false);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onConsoleCommand(ServerCommandEvent e) {
        String[] args = e.getCommand().split(" ");
        this.handleCommand("CONSOLE", args, true);
    }

    private void handleCommand(String senderName, String[] args, boolean fromConsole) {
        if (args.length == 0) {
            return;
        }
        String cmd = args[0].toLowerCase();
        if (cmd.equals("pay") && args.length >= 3 && !fromConsole) {
            Player p = Bukkit.getPlayerExact((String)senderName);
            if (p == null) {
                return;
            }
            String targetName = args[1];
            double amount = this.parseAmount(args[2]);
            if (amount <= 0.0) {
                return;
            }
            Player target = Bukkit.getPlayerExact((String)targetName);
            if (target != null && !target.equals((Object)p)) {
                this.payProcessingPlayers.add(p.getUniqueId());
                this.payProcessingPlayers.add(target.getUniqueId());
                this.addTransaction(p.getUniqueId(), new Transaction(Type.EXPENSE, "transaction-pay-sent", amount, target.getName()));
                this.addTransaction(target.getUniqueId(), new Transaction(Type.INCOME, "transaction-pay-received", amount, p.getName()));
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                    this.payProcessingPlayers.remove(p.getUniqueId());
                    this.payProcessingPlayers.remove(target.getUniqueId());
                }, 20L);
            }
        } else if (cmd.equals("eco") || cmd.equals("economy")) {
            if (args.length < 2) {
                return;
            }
            if (args[1].equalsIgnoreCase("reset") && args.length >= 3) {
                String targetName = args[2];
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
                if (target.hasPlayedBefore()) {
                    this.addTransaction(target.getUniqueId(), new Transaction(Type.YELLOW, "transaction-balance-reset", 0.0, target.getName()));
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set") && args.length >= 4) {
                String targetName = args[2];
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
                double amount = this.parseAmount(args[3]);
                if (amount <= 0.0) {
                    return;
                }
                if (target.hasPlayedBefore()) {
                    this.addTransaction(target.getUniqueId(), new Transaction(Type.YELLOW, "transaction-balance-set", amount, target.getName()));
                }
                return;
            }
            if (args.length < 4) {
                return;
            }
            String subcmd = args[1].toLowerCase();
            String targetName = args[2];
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            double amount = this.parseAmount(args[3]);
            if (amount <= 0.0) {
                return;
            }
            if (subcmd.equals("give")) {
                if (target.hasPlayedBefore()) {
                    this.addTransaction(target.getUniqueId(), new Transaction(Type.INCOME, "transaction-admin-give", amount, target.getName()));
                }
            } else if (subcmd.equals("take") && target.hasPlayedBefore()) {
                this.addTransaction(target.getUniqueId(), new Transaction(Type.EXPENSE, "transaction-admin-take", amount, target.getName()));
            }
        }
    }

    private double parseAmount(String s) {
        s = s.toUpperCase().replace(",", "").trim();
        double multiplier = 1.0;
        if (s.endsWith("K")) {
            multiplier = 1000.0;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("M")) {
            multiplier = 1000000.0;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("B")) {
            multiplier = 1.0E9;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("T")) {
            multiplier = 1.0E12;
            s = s.substring(0, s.length() - 1);
        }
        try {
            return Double.parseDouble(s) * multiplier;
        }
        catch (NumberFormatException ex) {
            return -1.0;
        }
    }

    private void updateFiles() {
        File[] langFiles;
        File configFile = new File(this.getDataFolder(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        config.options().copyDefaults(true);
        try (InputStream defaultsStream = this.getResource("config.yml");){
            if (defaultsStream != null) {
                YamlConfiguration defaultsConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultsStream));
                config.setDefaults((Configuration)defaultsConfig);
                config.save(configFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File langFolder = new File(this.getDataFolder(), "lang");
        if (langFolder.exists() && (langFiles = langFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File langFile : langFiles) {
                YamlConfiguration langConfig = YamlConfiguration.loadConfiguration((File)langFile);
                String langName = langFile.getName();
                try (InputStream defaultsStream = this.getResource("lang/" + langName);){
                    if (defaultsStream == null) continue;
                    YamlConfiguration defaultsLangConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultsStream));
                    langConfig.setDefaults((Configuration)defaultsLangConfig);
                    langConfig.options().copyDefaults(true);
                    langConfig.save(langFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.isOp()) {
                    sender.sendMessage(this.getTranslation("no-permissions", new String[0]));
                    return true;
                }
                this.reloadConfig();
                this.loadConfigValues();
                Bukkit.getScheduler().cancelTask(this.saveTaskId);
                this.saveTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::saveAll, this.saveIntervalTicks, this.saveIntervalTicks).getTaskId();
                this.taskId = Bukkit.getScheduler().runTaskTimer((Plugin)this, this::clearAllTransactions, this.cleanTransactionsPeriodMs / 50L, this.cleanTransactionsPeriodMs / 50L).getTaskId();
                sender.sendMessage(this.getTranslation("config-reloaded", new String[0]));
                this.saveAll();
                return true;
            }
            if (args[0].equalsIgnoreCase("clean")) {
                if (!sender.isOp()) {
                    sender.sendMessage(this.getTranslation("no-permissions", new String[0]));
                    return true;
                }
                this.clearAllTransactions();
                sender.sendMessage(this.getTranslation("cleanup-executed", new String[0]));
                return true;
            }
            if (args[0].equalsIgnoreCase("gmt")) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.getTranslation("in-game-only", new String[0]));
                    return true;
                }
                Player p = (Player)sender;
                if (args.length != 2) {
                    p.sendMessage(this.getTranslation("gmt-usage", new String[0]));
                    p.sendMessage(this.getTranslation("gmt-range", new String[0]));
                    return true;
                }
                try {
                    int newGmt = Integer.parseInt(args[1]);
                    if (newGmt < -12 || newGmt > 14) {
                        p.sendMessage(this.getTranslation("gmt-range", new String[0]));
                        return true;
                    }
                    this.playerGmtOffset.put(p.getUniqueId(), newGmt);
                    p.sendMessage(this.getTranslation("gmt-set", args[1]));
                    return true;
                }
                catch (NumberFormatException e) {
                    p.sendMessage(this.getTranslation("invalid-gmt", new String[0]));
                    return true;
                }
            }
            if (args[0].equalsIgnoreCase("update")) {
                if (!sender.isOp()) {
                    sender.sendMessage(this.getTranslation("no-permissions", new String[0]));
                    return true;
                }
                this.updateFiles();
                this.loadConfigValues();
                Bukkit.getScheduler().cancelTask(this.taskId);
                Bukkit.getScheduler().cancelTask(this.saveTaskId);
                this.taskId = Bukkit.getScheduler().runTaskTimer((Plugin)this, this::clearAllTransactions, this.cleanTransactionsPeriodMs / 50L, this.cleanTransactionsPeriodMs / 50L).getTaskId();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.getTranslation("update-success", new String[0]));
                return true;
            }
            if (args[0].equalsIgnoreCase("balance")) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.getTranslation("in-game-only", new String[0]));
                    return true;
                }
                Player p = (Player)sender;
                if (!this.allowBalanceToggle) {
                    p.sendMessage("\u00a7c" + this.getTranslation("balance-toggle-disabled", new String[0]));
                    return true;
                }
                if (args.length != 2) {
                    p.sendMessage(this.getTranslation("balance-usage", new String[0]));
                    return true;
                }
                if (args[1].equalsIgnoreCase("on")) {
                    this.showBalance.put(p.getUniqueId(), true);
                    p.sendMessage("\u00a7a" + this.getTranslation("balance-enabled", new String[0]));
                    this.saveAll();
                    return true;
                }
                if (args[1].equalsIgnoreCase("off")) {
                    this.showBalance.put(p.getUniqueId(), false);
                    p.sendMessage("\u00a7c" + this.getTranslation("balance-disabled", new String[0]));
                    this.saveAll();
                    return true;
                }
                p.sendMessage(this.getTranslation("balance-usage", new String[0]));
                return true;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.getTranslation("in-game-only", new String[0]));
                return true;
            }
            Player p = (Player)sender;
            if (!p.hasPermission("transactions.view.others")) {
                p.sendMessage("\u00a7c" + this.getTranslation("no-permissions", new String[0]));
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
            if (!target.hasPlayedBefore()) {
                p.sendMessage("\u00a7c" + this.getTranslation("player-not-found", args[0]));
                return true;
            }
            if (target.getUniqueId().equals(p.getUniqueId())) {
                p.sendMessage("\u00a7c" + this.getTranslation("cannot-view-self", new String[0]));
                return true;
            }
            this.openGUI(p, 0, target.getUniqueId(), target.getName());
            return true;
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            this.openGUI(p, 0);
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("transactions")) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                if ("gmt".startsWith(args[0].toLowerCase())) {
                    completions.add("gmt");
                }
                if (this.allowBalanceToggle && "balance".startsWith(args[0].toLowerCase())) {
                    completions.add("balance");
                }
                if (sender.isOp()) {
                    if ("reload".startsWith(args[0].toLowerCase())) {
                        completions.add("reload");
                    }
                    if ("clean".startsWith(args[0].toLowerCase())) {
                        completions.add("clean");
                    }
                    if ("update".startsWith(args[0].toLowerCase())) {
                        completions.add("update");
                    }
                }
                return completions;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("balance") && this.allowBalanceToggle) {
                return Arrays.asList("on", "off");
            }
        }
        return null;
    }

    void saveAll() {
        for (UUID uuid : new HashSet<UUID>(this.dirtyPlayers)) {
            File file = new File(this.dataFolder, String.valueOf(uuid) + ".yml");
            YamlConfiguration config = new YamlConfiguration();
            List list = this.transactions.getOrDefault(uuid, Collections.emptyList());
            for (int i = 0; i < list.size(); ++i) {
                Transaction t = (Transaction)list.get(i);
                String path = "t" + i;
                config.set(path + ".type", (Object)t.type.name());
                config.set(path + ".key", (Object)t.key);
                config.set(path + ".params", Arrays.asList(t.params));
                config.set(path + ".amount", (Object)t.amount);
                config.set(path + ".time", (Object)t.timestamp);
                config.set(path + ".rolledBack", (Object)t.rolledBack);
            }
            if (this.playerGmtOffset.containsKey(uuid)) {
                config.set("gmt", (Object)this.playerGmtOffset.get(uuid));
            }
            if (this.playerFilters.containsKey(uuid)) {
                FilterData filter = this.playerFilters.get(uuid);
                config.set("filter.type", (Object)filter.filterType.name());
                config.set("filter.time", (Object)filter.timePeriod.name());
            }
            config.set("show-balance", (Object)this.showBalance.getOrDefault(uuid, true));
            try {
                config.save(file);
            }
            catch (IOException ex) {
                this.getLogger().warning("Failed to save transactions for UUID: " + String.valueOf(uuid));
            }
            this.dirtyPlayers.remove(uuid);
        }
    }

    void loadAll() {
        File[] files = this.dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        for (File file : files) {
            UUID uuid = UUID.fromString(file.getName().replace(".yml", ""));
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            ArrayList<Transaction> list = new ArrayList<Transaction>();
            for (String key : config.getKeys(false)) {
                if (key.equalsIgnoreCase("gmt")) {
                    this.playerGmtOffset.put(uuid, config.getInt(key));
                    continue;
                }
                if (key.equalsIgnoreCase("filter")) {
                    try {
                        FilterData filter = new FilterData();
                        filter.filterType = FilterType.valueOf(config.getString("filter.type"));
                        filter.timePeriod = TimePeriod.valueOf(config.getString("filter.time"));
                        this.playerFilters.put(uuid, filter);
                    }
                    catch (IllegalArgumentException e) {}
                    continue;
                }
                if (key.equalsIgnoreCase("show-balance")) {
                    this.showBalance.put(uuid, config.getBoolean(key, true));
                    continue;
                }
                try {
                    Type type = Type.valueOf(config.getString(key + ".type"));
                    String transKey = config.getString(key + ".key");
                    List paramsList = config.getStringList(key + ".params");
                    String[] params = paramsList.toArray(new String[0]);
                    double amount = config.getDouble(key + ".amount");
                    long time = config.getLong(key + ".time");
                    boolean rolledBack = config.getBoolean(key + ".rolledBack", false);
                    if (time > currentTime) {
                        time = currentTime;
                    }
                    if (amount < 0.0) {
                        amount = 0.0;
                    }
                    if (transKey == null || transKey.isEmpty()) continue;
                    if (time <= 0L) {
                        time = System.currentTimeMillis();
                    }
                    Transaction t = new Transaction(type, transKey, amount, params, time);
                    t.rolledBack = rolledBack;
                    list.add(t);
                }
                catch (IllegalArgumentException e) {}
            }
            list.sort((t1, t2) -> Long.compare(t2.timestamp, t1.timestamp));
            this.transactions.put(uuid, list);
        }
        if (!this.allowBalanceToggle) {
            for (UUID uuid : this.showBalance.keySet()) {
                this.showBalance.put(uuid, false);
            }
        }
    }

    @EventHandler
    public void onDeposit(PlayerDepositEvent event) {
        OfflinePlayer offline = event.getOfflinePlayer();
        if (offline == null || offline.getUniqueId() == null) {
            return;
        }
        if (this.payProcessingPlayers.contains(offline.getUniqueId())) {
            return;
        }
        this.addTransaction(offline.getUniqueId(), new Transaction(Type.INCOME, "transaction-deposit", event.getAmount(), new String[0]));
    }

    @EventHandler
    public void onWithdraw(PlayerWithdrawEvent event) {
        OfflinePlayer offline = event.getOfflinePlayer();
        if (offline == null || offline.getUniqueId() == null) {
            return;
        }
        if (this.payProcessingPlayers.contains(offline.getUniqueId())) {
            return;
        }
        this.addTransaction(offline.getUniqueId(), new Transaction(Type.EXPENSE, "transaction-withdraw", event.getAmount(), new String[0]));
    }

    class Transaction {
        Type type;
        String key;
        String[] params;
        double amount;
        long timestamp;
        boolean rolledBack = false;

        Transaction(Type type, String key, double amount, String[] params, long timestamp) {
            this.type = type;
            this.key = key;
            this.params = params;
            this.amount = amount;
            this.timestamp = timestamp;
        }

        Transaction(Type type, String key, double amount, String ... params) {
            this(type, key, amount, params, System.currentTimeMillis());
        }
    }

    static enum Type {
        INCOME,
        EXPENSE,
        YELLOW;

    }

    class FilterData {
        FilterType filterType = FilterType.ALL;
        TimePeriod timePeriod = TimePeriod.ALL_TIME;

        FilterData() {
        }
    }

    static enum TimePeriod {
        ALL_TIME,
        LAST_7_DAYS,
        LAST_30_DAYS;

    }

    static enum FilterType {
        ALL,
        INCOME,
        EXPENSE;

    }
}

