/*
 * Decompiled with CFR 0.152.
 */
package com.tyurvib.transactions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.tyurvib.transactions.Transactions;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public class Updater {
    private final Transactions plugin;
    private final String modrinthProjectId;
    private String latestVersion;
    private boolean updateAvailable;

    public Updater(Transactions plugin, String modrinthProjectId) {
        this.plugin = plugin;
        this.modrinthProjectId = modrinthProjectId;
        this.updateAvailable = false;
        this.latestVersion = plugin.getDescription().getVersion();
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/" + this.modrinthProjectId + "/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Transactions-Plugin/" + this.plugin.getDescription().getVersion());
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (connection.getResponseCode() != 200) {
                    this.plugin.getLogger().warning("Failed to check for updates. Modrinth API returned: " + connection.getResponseCode());
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String jsonResponse = reader.lines().collect(Collectors.joining());
                    JsonArray versions = JsonParser.parseString((String)jsonResponse).getAsJsonArray();
                    if (versions.size() > 0) {
                        String currentVersion;
                        for (JsonElement versionElement : versions) {
                            JsonObject version = versionElement.getAsJsonObject();
                            JsonArray loaders = version.getAsJsonArray("loaders");
                            if (!loaders.contains((JsonElement)new JsonPrimitive("paper")) && !loaders.contains((JsonElement)new JsonPrimitive("fabric")) && !loaders.contains((JsonElement)new JsonPrimitive("bukkit"))) continue;
                            this.latestVersion = version.get("version_number").getAsString();
                            break;
                        }
                        if (this.isVersionNewer(this.latestVersion, currentVersion = this.plugin.getDescription().getVersion())) {
                            this.updateAvailable = true;
                            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.YELLOW) + "[Transactions] " + String.valueOf(ChatColor.RED) + "A new version (" + String.valueOf(ChatColor.YELLOW) + this.latestVersion + String.valueOf(ChatColor.RED) + ") is available! Your current version is " + String.valueOf(ChatColor.YELLOW) + currentVersion + String.valueOf(ChatColor.RED) + ".");
                        } else {
                            this.plugin.getLogger().info("You are running the latest version of the plugin.");
                        }
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not check for updates: " + e.getMessage());
            }
        });
    }

    private boolean isVersionNewer(String latest, String current) {
        String[] latestParts = latest.split("\\.");
        String[] currentParts = current.split("\\.");
        for (int i = 0; i < Math.min(latestParts.length, currentParts.length); ++i) {
            try {
                int latestInt = Integer.parseInt(latestParts[i]);
                int currentInt = Integer.parseInt(currentParts[i]);
                if (latestInt > currentInt) {
                    return true;
                }
                if (latestInt >= currentInt) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return !latest.equalsIgnoreCase(current);
            }
        }
        return latestParts.length > currentParts.length;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

