/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.world;

import com.mojang.datafixers.util.Pair;
import com.shanebeestudios.nms.api.util.McUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureApi {
    private static final StructureTemplateManager STRUCTURE_MANAGER = MinecraftServer.getServer().getStructureManager();
    private static final Registry<ConfiguredFeature<?, ?>> CONFIGURED_FEATURE_REGISTRY = McUtils.getRegistry(Registries.CONFIGURED_FEATURE);
    private static final Registry<PlacedFeature> PLACED_FEATURE_REGISTRY = McUtils.getRegistry(Registries.PLACED_FEATURE);
    private static final Registry<Structure> STRUCTURE_REGISTRY = McUtils.getRegistry(Registries.STRUCTURE);

    private StructureApi() {
    }

    public static boolean placeConfiguredFeature(@NotNull NamespacedKey featureKey, @NotNull Location location) {
        Pair<ServerLevel, BlockPos> levelPos = McUtils.getLevelPos(location);
        ServerLevel serverLevel = (ServerLevel)levelPos.getFirst();
        BlockPos blockPos = (BlockPos)levelPos.getSecond();
        ConfiguredFeature<?, ?> configuredFeature = McUtils.getRegistryValue(CONFIGURED_FEATURE_REGISTRY, featureKey);
        if (configuredFeature != null) {
            return configuredFeature.place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), serverLevel.getRandom(), blockPos);
        }
        return false;
    }

    public static boolean placePlacedFeature(@NotNull NamespacedKey featureKey, @NotNull Location location) {
        block3: {
            Pair<ServerLevel, BlockPos> levelPos = McUtils.getLevelPos(location);
            ServerLevel serverLevel = (ServerLevel)levelPos.getFirst();
            BlockPos blockPos = (BlockPos)levelPos.getSecond();
            PlacedFeature placedFeature = McUtils.getRegistryValue(PLACED_FEATURE_REGISTRY, featureKey);
            if (placedFeature != null) {
                try {
                    return placedFeature.place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), serverLevel.getRandom(), blockPos);
                }
                catch (IllegalStateException e) {
                    if (!e.getMessage().contains("biome")) break block3;
                    return placedFeature.placeWithBiomeCheck((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), serverLevel.getRandom(), blockPos);
                }
            }
        }
        return false;
    }

    @Nullable
    public static Location locateNearestStructure(@NotNull NamespacedKey structureKey, @NotNull Location location) {
        return StructureApi.locateNearestStructure(structureKey, location, 6400, true);
    }

    @Nullable
    public static Location locateNearestStructure(@NotNull NamespacedKey structureKey, @NotNull Location location, int radius, boolean findUnexplored) {
        Pair nearestMapStructure;
        Pair<ServerLevel, BlockPos> levelPos = McUtils.getLevelPos(location);
        ServerLevel serverLevel = (ServerLevel)levelPos.getFirst();
        BlockPos blockPos = (BlockPos)levelPos.getSecond();
        Holder.Reference<Structure> structureHolder = McUtils.getHolderReference(STRUCTURE_REGISTRY, structureKey);
        if (structureHolder != null && (nearestMapStructure = serverLevel.getChunkSource().getGenerator().findNearestMapStructure(serverLevel, (HolderSet)HolderSet.direct((Holder[])new Holder[]{structureHolder}), blockPos, radius, findUnexplored)) != null) {
            return McUtils.getLocation((BlockPos)nearestMapStructure.getFirst(), (Level)serverLevel);
        }
        return null;
    }

    @NotNull
    public static List<NamespacedKey> getConfiguredFeatures() {
        return McUtils.getRegistryKeys(CONFIGURED_FEATURE_REGISTRY);
    }

    @NotNull
    public static List<NamespacedKey> getPlacedFeatures() {
        return McUtils.getRegistryKeys(PLACED_FEATURE_REGISTRY);
    }

    @NotNull
    public static List<NamespacedKey> getStructures() {
        return McUtils.getRegistryKeys(STRUCTURE_REGISTRY);
    }

    public static List<NamespacedKey> getStructureTemplates() {
        ArrayList<NamespacedKey> keys = new ArrayList<NamespacedKey>();
        STRUCTURE_MANAGER.listTemplates().sorted(Comparator.comparing(ResourceLocation::toString)).forEach(resourceLocation -> keys.add(McUtils.getNamespacedKey(resourceLocation)));
        return keys;
    }
}

