/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.elements.sections.SecBiomeRegister;
import com.shanebeestudios.skbee.api.skript.base.Section;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Biome Definition Features")
@Description(value={"Apply features to biomes.", "Refer to [**BiomeDefinition**](https://minecraft.wiki/w/Biome_definition) and [**Placed Feature**](https://minecraft.wiki/w/Placed_feature) on McWiki for full details."})
@Examples(value={"register new biome:", "\tid: \"my_biomes:colorful_coast\"", "\thas_precipitation: true", "\ttemperature: 0.7", "\tdownfall: 0.8", "\tfeatures:", "\t\tunderground_ores:", "\t\t\tapply feature \"minecraft:ore_dirt\"", "\t\t\tapply feature \"minecraft:ore_coal_upper\"", "\t\t\tapply feature \"minecraft:ore_coal_lower\"", "\t\tvegetal_decoration:", "\t\t\tapply feature \"wythers:vegetation/bushes_mediterranean\"", "\t\t\tapply feature \"wythers:vegetation/trees_mediterranean_woods\"", "\t\t\tapply feature \"wythers:vegetation/placed_random_patch/mediterranean_lilacs\"", "\t\t\tapply feature \"minecraft:glow_lichen\"", "\t\t\tapply feature \"minecraft:patch_grass_savanna\"", "\t\t\tapply feature \"minecraft:patch_tall_grass_2\"", "\t\t\tapply feature \"minecraft:brown_mushroom_normal\"", "\t\t\tapply feature \"minecraft:red_mushroom_normal\"", "\t\t\tapply feature \"minecraft:patch_sugar_cane\""})
@Since(value={"1.1.0"})
public class SecBiomeFeatures
extends Section {
    private static final String[] PATTERNS = (String[])Arrays.stream(GenerationStep.Decoration.values()).map(GenerationStep.Decoration::getName).toArray(String[]::new);
    private int pattern;
    private Trigger trigger;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(SecBiomeRegister.BiomeEffectsEvent.class)) {
            Skript.error((String)"Can only be used in the 'features' section of a biome registration section.");
            return false;
        }
        this.pattern = matchedPattern;
        this.trigger = this.loadCode(sectionNode, "features", new Class[]{SecBiomeRegister.BiomeEffectsEvent.class});
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        if (event instanceof SecBiomeRegister.BiomeEffectsEvent) {
            SecBiomeRegister.BiomeEffectsEvent biomeEffectsEvent = (SecBiomeRegister.BiomeEffectsEvent)event;
            biomeEffectsEvent.setStep(this.pattern);
            Trigger.walk((TriggerItem)this.trigger, (Event)biomeEffectsEvent);
        }
        return this.getNext();
    }

    public String toString(@Nullable Event event, boolean debug) {
        return PATTERNS[this.pattern];
    }

    static {
        Skript.registerSection(SecBiomeFeatures.class, (String[])PATTERNS);
    }
}

