/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.elements.sections.SecBiomeRegister;
import com.shanebeestudios.skbee.api.skript.base.Section;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.MobCategory;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Biome Definition Spawners")
@Description(value={"Define which mobs will spawn in your biome.", "This is used in the `spawners` section of the biome registration section.", "See [**Biome Definition**](https://minecraft.wiki/w/Biome_definition) on McWiki for more details."})
@Examples(value={"spawners:", "\tcreature:", "\t\tapply spawner for sheep with weight 12 and with min count 4", "\tmonster:", "\t\tapply spawner for illusioner with weight 1 and with min count 1", "\t\tapply spawner for zombie, skeleton and creeper with weight 3 and with min count 1"})
@Since(value={"1.1.0"})
public class SecBiomeSpawners
extends Section {
    private static final String[] PATTERNS = (String[])Arrays.stream(MobCategory.values()).map(MobCategory::getName).toArray(String[]::new);
    private int pattern;
    private Trigger trigger;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(SecBiomeRegister.BiomeEffectsEvent.class)) {
            Skript.error((String)"Can only be used in the 'spawners' section of a biome registration section.");
            return false;
        }
        this.pattern = matchedPattern;
        this.trigger = this.loadCode(sectionNode, "features", new Class[]{SecBiomeRegister.BiomeEffectsEvent.class});
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        if (event instanceof SecBiomeRegister.BiomeEffectsEvent) {
            SecBiomeRegister.BiomeEffectsEvent biomeEffectsEvent = (SecBiomeRegister.BiomeEffectsEvent)event;
            biomeEffectsEvent.setStep(this.pattern);
            Trigger.walk((TriggerItem)this.trigger, (Event)biomeEffectsEvent);
        }
        return this.getNext();
    }

    public String toString(@Nullable Event event, boolean debug) {
        return PATTERNS[this.pattern];
    }

    static {
        Skript.registerSection(SecBiomeSpawners.class, (String[])PATTERNS);
    }
}

