/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.registry.EnchantmentDefinition;
import com.shanebeestudios.nms.api.skript.RegistrationSection;
import com.shanebeestudios.nms.elements.structures.StructRegistryRegistration;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="Enchantment Definition Registration")
@Description(value={"Register a new custom enchantment.", "There are a LOT of entries for this, so please refer to the [**Enchantment Definition**](https://minecraft.wiki/w/Enchantment_definition) page on McWiki for all the details.", "More examples and detailed information provided in the [**SkNMS Wiki**](https://github.com/ShaneBeee/SkNMS/wiki/Custom-Enchantments).", "", "**NOTES**:", "- Custom enchantments cannot be removed at runtime (a restart is the only way to get rid of them or change them after they're registered).", "- If you make a change to your custom enchantment, you'll have to restart your server (reloading the script just won't cut it).", "- I did not add an `effects` entry as it's super duper convoluted, and you can handle what your enchantment does via code.", "", "**DEFINITION ENTRIES**:", "These entries are directly related to the Enchantment Definition in Minecraft (as seen in the above mentioned wiki).", "I'm only going to touch on a few here, as there are so many to type out, see the above mentioned wiki for full details.", "- `id` = Takes in a string to identify your new enchantment, think vanilla \"minecraft:sharpness\".", "- `description` = Takes in a text component (from SkBee) or string, this is how your enchantment will show up in lore.", "- `exclusive_set` = The enchantments your enchantment will not work with. Either a single string (enchantment tag) or a list of enchantments.", "- `supported_items/primary_items` = See wiki for explanations. Either a single string (item tag) or a list of items.", "- `slots` = I don't think this is needed as it would be handled by the effects in Minecraft, which we aren't using here.", "", "**TAG ENTRIES**:", "These entries are related to the Minecraft Enchantment tags that this enchantment will be added to (all default to false).", "- `is_cursed` = Will add to the `#minecraft:curse` tag making your item a cursed item (These enchantments have red colored description and cannot be removed with a grindstone).", "- `is_treasure` = Will add to the `#minecraft:treasure` tag.", "- `is_tradeable` = Will add to the `#minecraft:treasure` and `#minecraft:double_trade_price` tags.", "- `is_discoverable` = Will add to the `#minecraft:in_enchanting_table` tag if not cursed or a treasure.", "- `is_on_random_loot` = Will add to the `#minecraft:on_random_loot` tag and can be found on naturally generated equipment from loot tables.", "- `is_on_mob_spawn_equipment` = If not a treasure, will add to the `#minecraft:on_mob_spawn_equipment` tag and can be found on spawned mobs' equipment.", "- `is_on_traded_equipment` = If not a treasure, will add to the `#minecraft:on_traded_equipment` tag and can be found on equipment sold by villagers.", "", "**WARNINGS**:", "- Enchantments are not supposed to be created at runtime. This method is super hacky and I highly HIGHLY recommend just using a datapack instead.", "- You must ensure 1 of 2 things:", "  - If your spawn keeps loaded in your world, you must make sure no items are in any chests or anything in that area that contain these enchantments.", "  - Or just make sure to turn off your spawn chunk radius (set the gamerule `spawnChunkRadius` to 0 for all worlds).", "  This is due to these enchantments will register to Minecraft via Skript AFTER your world/spawn chunks load.", "- Do not, I repeat... DO NOT save custom enchantments to variables (Skript will panic trying to load enchantments that arent registered yet). RAM/Memory variables are safe!", "That said, enjoy your new custom enchantments."})
@Examples(value={"# Wither Sword Enchantment", "registry registration:", "\tregister enchantment:", "\t\tid: \"my_pack:wither\"", "\t\tdescription: mini message from \"<red>Wither\"", "\t\tsupported_items: \"minecraft:swords\"", "\t\tmax_level: 5", "", "on damage of mob by player:", "\tset {_level} to enchantment level of my_pack:wither of attacker's tool", "\tif {_level} > 0:", "\t\tset {_time} to \"%{_level} * 3% seconds\" parsed as timespan", "\t\tapply wither to victim for {_time}"})
@Since(value={"1.0.0"})
public class SecEnchantmentRegister
extends RegistrationSection {
    private static final EntryValidator VALIDATOR;
    private Expression<String> id;
    private Expression<?> description;
    private Expression<?> exclusiveSet;
    private Expression<?> supportedItems;
    private Expression<?> primaryItems;
    private Expression<Integer> weight;
    private Expression<Integer> maxLevel;
    private Expression<Integer> minCostBase;
    private Expression<Integer> minCostPerLevelAboveFirst;
    private Expression<Integer> maxCostBase;
    private Expression<Integer> maxCostPerLevelAboveFirst;
    private Expression<Integer> anvilCost;
    private Expression<EquipmentSlotGroup> slots;
    private Expression<Boolean> isCursed;
    private Expression<Boolean> isTreasure;
    private Expression<Boolean> isTradeable;
    private Expression<Boolean> isDiscoverable;
    private Expression<Boolean> isOnRandomLoot;
    private Expression<Boolean> isOnMobSpawnEquipment;
    private Expression<Boolean> isOnTradedEquipment;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentStructure(StructRegistryRegistration.class)) {
            Skript.error((String)"Enchantments can only be registered in a 'registry registration' structure");
            return false;
        }
        if (sectionNode == null) {
            return false;
        }
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.id = (Expression)container.getOptional("id", false);
        this.description = (Expression)container.getOptional("description", false);
        this.exclusiveSet = (Expression)container.getOptional("exclusive_set", false);
        this.supportedItems = (Expression)container.getOptional("supported_items", false);
        this.primaryItems = (Expression)container.getOptional("primary_items", false);
        this.weight = (Expression)container.getOptional("weight", false);
        this.maxLevel = (Expression)container.getOptional("max_level", false);
        this.minCostBase = (Expression)container.getOptional("min_cost_base", false);
        this.minCostPerLevelAboveFirst = (Expression)container.getOptional("min_cost_per_level_above_first", false);
        this.maxCostBase = (Expression)container.getOptional("max_cost_base", false);
        this.maxCostPerLevelAboveFirst = (Expression)container.getOptional("max_cost_per_level_above_first", false);
        this.anvilCost = (Expression)container.getOptional("anvil_cost", false);
        this.slots = (Expression)container.getOptional("slots", false);
        this.isCursed = (Expression)container.getOptional("is_cursed", false);
        this.isTreasure = (Expression)container.getOptional("is_treasure", false);
        this.isTradeable = (Expression)container.getOptional("is_tradeable", false);
        this.isDiscoverable = (Expression)container.getOptional("is_discoverable", false);
        this.isOnRandomLoot = (Expression)container.getOptional("is_on_random_loot", false);
        this.isOnMobSpawnEquipment = (Expression)container.getOptional("is_on_mob_spawn_equipment", false);
        this.isOnTradedEquipment = (Expression)container.getOptional("is_on_traded_equipment", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Material material;
        ItemType itemType;
        String tag;
        NamespacedKey key;
        String string;
        TriggerItem next = this.getNext();
        if (this.id == null || this.description == null || this.supportedItems == null) {
            return next;
        }
        NamespacedKey namespacedKey = Util.getNamespacedKey((String)((String)this.id.getSingle(event)), (boolean)false);
        if (namespacedKey == null || Registry.ENCHANTMENT.get(namespacedKey) != null) {
            return next;
        }
        EnchantmentDefinition.Builder builder = new EnchantmentDefinition.Builder();
        builder.id(namespacedKey);
        TextComponent descriptionComponent = Component.text((String)"Unnamed");
        Object description = this.description.getSingle(event);
        if (description != null) {
            if (description instanceof ComponentWrapper) {
                ComponentWrapper cw = (ComponentWrapper)description;
                descriptionComponent = cw.getComponent();
            } else if (description instanceof String) {
                String string2 = (String)description;
                descriptionComponent = ComponentWrapper.fromText((String)string2).getComponent();
            }
        }
        builder.description((Component)descriptionComponent);
        if (this.exclusiveSet != null) {
            for (Object object : this.exclusiveSet.getArray(event)) {
                if (object instanceof String) {
                    string = (String)object;
                    NamespacedKey key2 = Util.getNamespacedKey((String)string.replace("#", ""), (boolean)false);
                    if (key2 != null && builder.exclusiveSetTag(key2)) break;
                    this.warning("Invalid tag '" + string + "'");
                    break;
                }
                if (!(object instanceof Enchantment)) continue;
                Enchantment enchantment = (Enchantment)object;
                builder.addExclusiveSet(enchantment);
            }
        }
        for (Object object : this.supportedItems.getArray(event)) {
            if (object instanceof String) {
                string = (String)object;
                key = Util.getNamespacedKey((String)string.replace("#", ""), (boolean)false);
                if (key != null && builder.supportedItemTag(key)) break;
                tag = key != null ? key.toString() : string;
                this.warning("Invalid tag '" + tag + "'");
                break;
            }
            if (!(object instanceof ItemType)) continue;
            itemType = (ItemType)object;
            material = itemType.getMaterial();
            if (!material.isItem()) {
                this.warning("Material '" + String.valueOf(material) + "' is not a. item.");
                continue;
            }
            builder.addSupportedItem(material);
        }
        if (this.primaryItems != null) {
            for (Object object : this.primaryItems.getArray(event)) {
                if (object instanceof String) {
                    string = (String)object;
                    key = Util.getNamespacedKey((String)string.replace("#", ""), (boolean)false);
                    if (key != null && builder.primaryItemTag(key)) break;
                    tag = key != null ? key.toString() : string;
                    this.warningRegex("Invalid tag '" + tag + "'", "\".+\"");
                    break;
                }
                if (!(object instanceof ItemType)) continue;
                itemType = (ItemType)object;
                material = itemType.getMaterial();
                if (!material.isItem()) {
                    this.warning("Material '" + String.valueOf(material) + "' is not a. item.");
                    continue;
                }
                builder.addPrimaryItem(material);
            }
        }
        if (this.weight != null) {
            this.weight.getOptionalSingle(event).ifPresent(builder::weight);
        }
        if (this.maxLevel != null) {
            this.maxLevel.getOptionalSingle(event).ifPresent(builder::maxLevel);
        }
        if (this.minCostBase != null && this.minCostPerLevelAboveFirst != null) {
            this.minCostBase.getOptionalSingle(event).ifPresent(builder::minCostBase);
            this.minCostPerLevelAboveFirst.getOptionalSingle(event).ifPresent(builder::minCostPerLevelAboveFirst);
        }
        if (this.maxCostBase != null && this.maxCostPerLevelAboveFirst != null) {
            this.maxCostBase.getOptionalSingle(event).ifPresent(builder::maxCostBase);
            this.maxCostPerLevelAboveFirst.getOptionalSingle(event).ifPresent(builder::maxCostPerLevelAboveFirst);
        }
        if (this.anvilCost != null) {
            this.anvilCost.getOptionalSingle(event).ifPresent(builder::anvilCost);
        }
        if (this.slots != null) {
            for (EquipmentSlotGroup slot : (EquipmentSlotGroup[])this.slots.getArray(event)) {
                builder.addSlot(slot);
            }
        }
        if (this.isCursed != null) {
            this.isCursed.getOptionalSingle(event).ifPresent(builder::isCursed);
        }
        if (this.isTreasure != null) {
            this.isTreasure.getOptionalSingle(event).ifPresent(builder::isTreasure);
        }
        if (this.isTradeable != null) {
            this.isTradeable.getOptionalSingle(event).ifPresent(builder::isTradeable);
        }
        if (this.isDiscoverable != null) {
            this.isDiscoverable.getOptionalSingle(event).ifPresent(builder::isDiscoverable);
        }
        if (this.isOnRandomLoot != null) {
            this.isOnRandomLoot.getOptionalSingle(event).ifPresent(builder::isOnRandomLoot);
        }
        if (this.isOnMobSpawnEquipment != null) {
            this.isOnMobSpawnEquipment.getOptionalSingle(event).ifPresent(builder::isOnMobSpawnEquipment);
        }
        if (this.isOnTradedEquipment != null) {
            this.isOnTradedEquipment.getOptionalSingle(event).ifPresent(builder::isOnTradedEquipment);
        }
        builder.build().register();
        return next;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "register enchantment";
    }

    static {
        Class[] somethingClasses = new Class[]{ComponentWrapper.class, String.class};
        Class[] exclusiveSetClasses = new Class[]{Enchantment.class, String.class};
        Class[] itemAndTagClasses = new Class[]{ItemType.class, String.class};
        VALIDATOR = SimpleEntryValidator.builder().addRequiredEntry("id", String.class).addRequiredEntry("description", somethingClasses).addRequiredEntry("supported_items", itemAndTagClasses).addOptionalEntry("exclusive_set", exclusiveSetClasses).addOptionalEntry("primary_items", itemAndTagClasses).addOptionalEntry("weight", Integer.class).addOptionalEntry("max_level", Integer.class).addOptionalEntry("min_cost_base", Integer.class).addOptionalEntry("min_cost_per_level_above_first", Integer.class).addOptionalEntry("max_cost_base", Integer.class).addOptionalEntry("max_cost_per_level_above_first", Integer.class).addOptionalEntry("anvil_cost", Integer.class).addOptionalEntry("slots", EquipmentSlotGroup.class).addOptionalEntry("is_cursed", Boolean.class).addOptionalEntry("is_treasure", Boolean.class).addOptionalEntry("is_tradeable", Boolean.class).addOptionalEntry("is_discoverable", Boolean.class).addOptionalEntry("is_on_random_loot", Boolean.class).addOptionalEntry("is_on_mob_spawn_equipment", Boolean.class).addOptionalEntry("is_on_traded_equipment", Boolean.class).build();
        Skript.registerSection(SecEnchantmentRegister.class, (String[])new String[]{"register [new] [custom] enchantment"});
    }
}

