/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections.dialog.inputs;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.util.McUtils;
import com.shanebeestudios.nms.elements.sections.dialog.event.DialogRegisterEvent;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dialog.Input;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.server.dialog.input.NumberRangeInput;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Dialog - Number Range Input")
@Description(value={"A number slider input to be used in an `inputs` section of a dialog.", "See [**Input Control on SkNMS wiki**](https://github.com/ShaneBeee/SkNMS/wiki/Dialogs#input-control)and [**Input Control on McWiki**](https://minecraft.wiki/w/Dialog#Input_control_format) for further info.", "**Entries**:", "- `key` = String identifier of value used when submitting data, must be a valid template argument (letters, digits and _).", "- `label` = A string/text component to be displayed to the left of the input.", "- `label_format` = A translation key to be used for building label (first argument is contents of label field, second argument is current value). ", "Defaults to \"options.generic_value\".", "- `width` = Integer value between 1 and 1024 \u2014 The width of the input. Defaults to 200. [Optional]", "- `start` = The minimum number of the slider.", "- `end` = The maximum number of the slider.", "- `step` = Step size (If present, only values of initial+<anyinteger>*step will be allowed. If absent, any value from the range is allowed). [Optional]", "- `initial` = The initial increment value of the slider. Defaults to the middle of the range. [Optional]"})
@Examples(value={"add number range input:", "\tkey: \"some_key\"", "\tlabel: \"Slide for Health\"", "\twidth: 300", "\tstart: 0", "\tend: 20", "\tstep: 1", "\tinitial: 20"})
@Since(value={"1.3.0"})
public class SecNumberRangeInput
extends Section {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private Expression<String> key;
    private Expression<?> label;
    private Expression<String> labelFormat;
    private Expression<Integer> width;
    private Expression<Float> start;
    private Expression<Float> end;
    private Expression<Float> step;
    private Expression<Float> initial;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(DialogRegisterEvent.class)) {
            Skript.error((String)"A number range input can only be used in an 'inputs' section of a dialog.");
            return false;
        }
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.key = (Expression)container.getOptional("key", false);
        this.label = (Expression)container.getOptional("label", false);
        this.labelFormat = (Expression)container.getOptional("label_format", false);
        this.width = (Expression)container.getOptional("width", false);
        this.start = (Expression)container.getOptional("start", false);
        this.end = (Expression)container.getOptional("end", false);
        this.step = (Expression)container.getOptional("step", false);
        this.initial = (Expression)container.getOptional("initial", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Integer intSingle;
        String labelSingle;
        TriggerItem next = this.getNext();
        String key = (String)this.key.getSingle(event);
        if (key == null) {
            return next;
        }
        Object labelWrapped = this.label.getSingle(event);
        Component label = McUtils.getNMSComponent(labelWrapped);
        if (label == null) {
            this.error("Label is invalid: " + this.label.toString(event, true));
            return next;
        }
        String labelFormat = "options.generic_value";
        if (this.labelFormat != null && (labelSingle = (String)this.labelFormat.getSingle(event)) != null) {
            labelFormat = labelSingle.trim();
        }
        int width = 200;
        if (this.width != null && (intSingle = (Integer)this.width.getSingle(event)) != null) {
            width = intSingle;
        }
        Float initial = (Float)this.initial.getSingle(event);
        Float start = (Float)this.start.getSingle(event);
        if (start == null) {
            this.error("Start is invalid: " + this.start.toString(event, true));
            return next;
        }
        Float end = (Float)this.end.getSingle(event);
        if (end == null) {
            this.error("End is invalid: " + this.end.toString(event, true));
            return next;
        }
        Float step = (Float)this.step.getSingle(event);
        if (event instanceof DialogRegisterEvent) {
            DialogRegisterEvent actionEvent = (DialogRegisterEvent)event;
            NumberRangeInput.RangeInfo rangeInfo = new NumberRangeInput.RangeInfo(start.floatValue(), end.floatValue(), Optional.ofNullable(initial), Optional.ofNullable(step));
            NumberRangeInput input = new NumberRangeInput(width, label, labelFormat, rangeInfo);
            actionEvent.addInput(new Input(key, (InputControl)input));
        }
        return next;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "add number range input";
    }

    static {
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("key", null, false, String.class));
        Class[] compClasses = new Class[]{String.class, ComponentWrapper.class};
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("label", null, false, compClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("label_format", null, true, String.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("width", (Expression)new SimpleLiteral((Object)200, true), true, Integer.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("start", null, false, Float.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("end", null, false, Float.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("step", null, true, Float.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("initial", null, false, Float.class));
        Skript.registerSection(SecNumberRangeInput.class, (String[])new String[]{"add number range input"});
    }
}

