/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.structures;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LoopSection;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.sections.SecConditional;
import com.shanebeestudios.nms.api.skript.RegistrationSection;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.structure.Structure;

@Name(value="Registry Registration")
@Description(value={"This structure is used for registering new registry entries such as custom biomes and enchantments."})
@Since(value={"1.1.0"})
public class StructRegistryRegistration
extends Structure {
    private static final Structure.Priority PRIORITY = new Structure.Priority(201);

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, @Nullable EntryContainer entryContainer) {
        if (entryContainer == null) {
            return false;
        }
        this.getParser().setCurrentStructure((Structure)this);
        for (Node node : entryContainer.getSource()) {
            SectionNode sectionNode;
            String key;
            if (!(node instanceof SectionNode) || (key = (sectionNode = (SectionNode)node).getKey()) == null) continue;
            Section something = Section.parse((String)key, (String)"Invalid section", (SectionNode)sectionNode, null);
            if (something instanceof RegistrationSection || something instanceof LoopSection || something instanceof SecConditional) {
                Section.walk((TriggerItem)something, (Event)new RegistrationSection.RegistrationEvent());
                continue;
            }
            Skript.error((String)("Invalid section entry '" + key + "' cannot be used in a registration structure."));
            return false;
        }
        return true;
    }

    public boolean load() {
        return true;
    }

    public Structure.Priority getPriority() {
        return PRIORITY;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "registry registration";
    }

    static {
        Skript.registerStructure(StructRegistryRegistration.class, (String[])new String[]{"registry registration"});
    }
}

