/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.shanebeestudios.nms.api.packet.PlayerPacketListener;
import com.shanebeestudios.nms.api.util.Utils;
import com.shanebeestudios.nms.metrics.bukkit.Metrics;
import com.shanebeestudios.nms.metrics.charts.SimplePie;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SkNMS
extends JavaPlugin {
    private static SkNMS PLUGIN_INSTANCE;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onEnable() {
        PLUGIN_INSTANCE = this;
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (pluginManager.getPlugin("Skript") != null && pluginManager.getPlugin("SkBee") != null) {
            Utils.log("Loading Skript Addon.");
            if (!Skript.isAcceptRegistrations()) {
                Utils.error("Skript is no longer accepting registration, addon not loading!");
                return;
            }
            SkriptAddon skriptAddon = Skript.registerAddon((JavaPlugin)this);
            try {
                skriptAddon.loadClasses("com.shanebeestudios.nms.elements", new String[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            Utils.error("'Skript' and/or 'SkBee' missing, SkNMS not loading!");
            return;
        }
        this.loadMetrics();
        PlayerPacketListener.registerListener((Plugin)this);
    }

    public void onDisable() {
    }

    public static SkNMS getInstance() {
        return PLUGIN_INSTANCE;
    }

    private void loadMetrics() {
        Metrics metrics = new Metrics(this, 24666);
        metrics.addCustomChart(new SimplePie("skript_version", () -> Skript.getVersion().toString()));
    }
}

