/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.packet;

import com.shanebeestudios.nms.SkNMS;
import com.shanebeestudios.nms.api.packet.DynamicClickEvent;
import com.shanebeestudios.nms.api.util.McUtils;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomClickActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerPacketListener
implements Listener {
    private static boolean registered = false;
    private static boolean nbtEnabled = false;

    public static void registerListener(Plugin plugin) {
        if (registered) {
            throw new IllegalStateException("Listener is already registered!");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerPacketListener(), plugin);
        registered = true;
        nbtEnabled = NBTApi.isEnabled();
    }

    private PlayerPacketListener() {
    }

    @EventHandler
    private void onPlayerJoin(PlayerJoinEvent event) {
        final Player bukkitPlayer = event.getPlayer();
        ServerPlayer serverPlayer = ((CraftPlayer)bukkitPlayer).getHandle();
        ChannelDuplexHandler handler = new ChannelDuplexHandler(this){

            public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
                Packet packet;
                if (msg instanceof Packet && (packet = (Packet)msg) instanceof ServerboundCustomClickActionPacket) {
                    ServerboundCustomClickActionPacket actionPacket = (ServerboundCustomClickActionPacket)packet;
                    if (nbtEnabled) {
                        NBTContainer nbtCompound;
                        Object t;
                        ResourceLocation id = actionPacket.id();
                        NamespacedKey nsk = McUtils.getNamespacedKey(id);
                        Optional payload = actionPacket.payload();
                        if (payload.isPresent() && (t = payload.get()) instanceof CompoundTag) {
                            CompoundTag compoundTag = (CompoundTag)t;
                            nbtCompound = new NBTContainer((Object)compoundTag);
                        } else {
                            nbtCompound = null;
                        }
                        Bukkit.getScheduler().runTask((Plugin)SkNMS.getInstance(), () -> new DynamicClickEvent(bukkitPlayer, nsk, (NBTCompound)nbtCompound).callEvent());
                    }
                }
                super.channelRead(ctx, msg);
            }
        };
        serverPlayer.connection.connection.channel.pipeline().addBefore("packet_handler", bukkitPlayer.getName(), (ChannelHandler)handler);
    }
}

