/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.registry;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.shanebeestudios.nms.SkNMS;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.CraftRegistry;

public class DumpRegistry<N, B extends Keyed> {
    private static final RegistryOps<JsonElement> REGISTRY_OPS = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)MinecraftServer.getServer().registryAccess());
    private static final File DATA_FOLDER = SkNMS.getInstance().getDataFolder();
    private static final Map<Class<?>, DumpRegistry<?, ?>> MAP = new HashMap();
    public static final String PATTERN;
    private final String name;
    private final String registryPath;
    private final Codec<N> codec;

    private static <N, B extends Keyed> void register(String name, ResourceKey<Registry<N>> registry, Codec<N> codec, Class<B> bukkitClass) {
        MAP.put(bukkitClass, new DumpRegistry<N, B>(name, registry, codec));
    }

    public static void dumpObject(Object object) {
        MAP.forEach((bukkitClass, dumpRegistry) -> {
            if (bukkitClass.isAssignableFrom(object.getClass())) {
                dumpRegistry.dump(object);
            }
        });
    }

    public DumpRegistry(String name, ResourceKey<Registry<N>> registry, Codec<N> codec) {
        this.name = name;
        this.registryPath = registry.location().getPath();
        this.codec = codec;
    }

    private void dump(Object bukkitObject) {
        NamespacedKey namespacedKey = ((Keyed)bukkitObject).getKey();
        File file = new File(DATA_FOLDER, "data/" + namespacedKey.namespace() + "/" + this.registryPath + "/" + namespacedKey.getKey() + ".json");
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            return;
        }
        Object nmsObject = CraftRegistry.bukkitToMinecraft((Keyed)((Keyed)bukkitObject));
        DataResult jsonData = this.codec.encodeStart(REGISTRY_OPS, nmsObject);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.writeString(file.toPath(), (CharSequence)gson.toJson((JsonElement)jsonData.getOrThrow()), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DumpRegistry.register("biomes", Registries.BIOME, net.minecraft.world.level.biome.Biome.DIRECT_CODEC, Biome.class);
        DumpRegistry.register("enchantments", Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC, org.bukkit.enchantments.Enchantment.class);
        List<String> patterns = MAP.values().stream().map(dumpRegistry -> dumpRegistry.name).toList();
        PATTERN = Joiner.on((String)"/").join(patterns);
    }
}

