/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.registry;

import com.shanebeestudios.nms.api.util.RegistryUtils;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;

public class EnchantmentDefinition {
    private final NamespacedKey id;
    private final Enchantment enchantment;
    private final TagData tagData;

    private EnchantmentDefinition(NamespacedKey id, Enchantment enchantment, TagData tagData) {
        this.id = id;
        this.enchantment = enchantment;
        this.tagData = tagData;
    }

    public NamespacedKey getId() {
        return this.id;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public TagData getTagData() {
        return this.tagData;
    }

    public org.bukkit.enchantments.Enchantment register() {
        return RegistryUtils.registerEnchantment(this);
    }

    public static class TagData {
        public boolean isCursed;
        public boolean isTreasure;
        public boolean isTradeable;
        public boolean isDiscoverable;
        public boolean isOnRandomLoot;
        public boolean isOnMobSpawnEquipment;
        public boolean isOnTradedEquipment;

        public TagData(boolean isCursed, boolean isTreasure, boolean isTradeable, boolean isDiscoverable, boolean isOnRandomLoot, boolean isOnMobSpawnEquipment, boolean isOnTradedEquipment) {
            this.isCursed = isCursed;
            this.isTreasure = isTreasure;
            this.isTradeable = isTradeable;
            this.isDiscoverable = isDiscoverable;
            this.isOnRandomLoot = isOnRandomLoot;
            this.isOnMobSpawnEquipment = isOnMobSpawnEquipment;
            this.isOnTradedEquipment = isOnTradedEquipment;
        }
    }

    public static class Builder {
        NamespacedKey id;
        net.kyori.adventure.text.Component description;
        List<org.bukkit.enchantments.Enchantment> exclusiveSet = new ArrayList<org.bukkit.enchantments.Enchantment>();
        TagKey<Enchantment> exclusiveSetTag;
        List<Material> supportedItems = new ArrayList<Material>();
        TagKey<Item> supportedItemsTag;
        List<Material> primaryItems = new ArrayList<Material>();
        TagKey<Item> primaryItemsTag;
        int weight = 1;
        int maxLevel = 1;
        int minCostBase = 1;
        int minCostPerLevelAboveFirst = 1;
        int maxCostBase = 1;
        int maxCostPerLevelAboveFirst = 1;
        int anvilCost = 1;
        boolean isCursed = false;
        boolean isTreasure = false;
        boolean isTradeable = false;
        boolean isDiscoverable = false;
        boolean isOnRandomLoot = false;
        boolean isOnMobSpawnEquipment = false;
        boolean isOnTradedEquipment = false;
        List<org.bukkit.inventory.EquipmentSlotGroup> slots = new ArrayList<org.bukkit.inventory.EquipmentSlotGroup>();

        public void id(NamespacedKey id) {
            this.id = id;
        }

        public void description(net.kyori.adventure.text.Component description) {
            this.description = description;
        }

        public void addExclusiveSet(org.bukkit.enchantments.Enchantment exclusiveSet) {
            this.exclusiveSet.add(exclusiveSet);
        }

        public boolean exclusiveSetTag(NamespacedKey tag) {
            Optional holders;
            Registry<Enchantment> enchantRegistry = RegistryUtils.getEnchantRegistry();
            TagKey<Enchantment> tagKey = RegistryUtils.getTagKey(enchantRegistry, tag.toString());
            if (tagKey != null && (holders = enchantRegistry.get(tagKey)).isPresent()) {
                this.exclusiveSetTag = tagKey;
                return true;
            }
            return false;
        }

        public boolean supportedItemTag(NamespacedKey tag) {
            Optional holders;
            Registry<Item> itemRegistry = RegistryUtils.getItemRegistry();
            TagKey<Item> tagKey = RegistryUtils.getTagKey(itemRegistry, tag.toString());
            if (tagKey != null && (holders = itemRegistry.get(tagKey)).isPresent()) {
                this.supportedItemsTag = tagKey;
                return true;
            }
            return false;
        }

        public void addSupportedItem(Material item) {
            this.supportedItems.add(item);
        }

        public boolean primaryItemTag(NamespacedKey tag) {
            Optional holders;
            Registry<Item> itemRegistry = RegistryUtils.getItemRegistry();
            TagKey<Item> tagKey = RegistryUtils.getTagKey(itemRegistry, tag.toString());
            if (tagKey != null && (holders = itemRegistry.get(tagKey)).isPresent()) {
                this.primaryItemsTag = tagKey;
                return true;
            }
            return false;
        }

        public void addPrimaryItem(Material item) {
            this.primaryItems.add(item);
        }

        public void weight(int weight) {
            this.weight = weight;
        }

        public void maxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public void minCostBase(int minCostBase) {
            this.minCostBase = minCostBase;
        }

        public void minCostPerLevelAboveFirst(int minCostPerLevelAboveFirst) {
            this.minCostPerLevelAboveFirst = minCostPerLevelAboveFirst;
        }

        public void maxCostBase(int maxCostBase) {
            this.maxCostBase = maxCostBase;
        }

        public void maxCostPerLevelAboveFirst(int maxCostPerLevelAboveFirst) {
            this.maxCostPerLevelAboveFirst = maxCostPerLevelAboveFirst;
        }

        public void anvilCost(int anvilCost) {
            this.anvilCost = anvilCost;
        }

        public void addSlot(org.bukkit.inventory.EquipmentSlotGroup slot) {
            this.slots.add(slot);
        }

        public void isCursed(boolean cursed) {
            this.isCursed = cursed;
        }

        public void isTreasure(boolean treasure) {
            this.isTreasure = treasure;
        }

        public void isTradeable(boolean tradeable) {
            this.isTradeable = tradeable;
        }

        public void isDiscoverable(boolean discoverable) {
            this.isDiscoverable = discoverable;
        }

        public void isOnRandomLoot(boolean onRandomLoot) {
            this.isOnRandomLoot = onRandomLoot;
        }

        public void isOnMobSpawnEquipment(boolean onMobSpawnEquipment) {
            this.isOnMobSpawnEquipment = onMobSpawnEquipment;
        }

        public void isOnTradedEquipment(boolean onTradedEquipment) {
            this.isOnTradedEquipment = onTradedEquipment;
        }

        private HolderSet<Enchantment> createExclusiveSet() {
            HolderSet exclusiveSet = HolderSet.empty();
            Registry<Enchantment> enchantRegistry = RegistryUtils.getEnchantRegistry();
            if (this.exclusiveSetTag != null) {
                Optional holders = enchantRegistry.get(this.exclusiveSetTag);
                if (holders.isPresent()) {
                    exclusiveSet = (HolderSet)holders.get();
                }
            } else if (!this.exclusiveSet.isEmpty()) {
                ArrayList<Holder> enchants = new ArrayList<Holder>();
                for (org.bukkit.enchantments.Enchantment bukkitEnchant : this.exclusiveSet) {
                    Enchantment enchantment = CraftEnchantment.bukkitToMinecraft((org.bukkit.enchantments.Enchantment)bukkitEnchant);
                    enchants.add(enchantRegistry.wrapAsHolder((Object)enchantment));
                }
                exclusiveSet = HolderSet.direct(enchants);
            }
            return exclusiveSet;
        }

        private HolderSet<Item> createItemSet(TagKey<Item> tagKey, List<Material> sets) {
            HolderSet itemSet = HolderSet.empty();
            Registry<Item> itemRegistry = RegistryUtils.getItemRegistry();
            if (tagKey != null) {
                Optional holders = itemRegistry.get(tagKey);
                if (holders.isPresent()) {
                    itemSet = (HolderSet)holders.get();
                }
            } else if (!sets.isEmpty()) {
                ArrayList<Holder> itemSetList = new ArrayList<Holder>();
                for (Material material : sets) {
                    if (!material.isItem()) continue;
                    Item item = CraftMagicNumbers.getItem((Material)material);
                    itemSetList.add(itemRegistry.wrapAsHolder((Object)item));
                }
                itemSet = HolderSet.direct(itemSetList);
            }
            return itemSet;
        }

        private HolderSet<Item> createSupportedItems() {
            return this.createItemSet(this.supportedItemsTag, this.supportedItems);
        }

        private Optional<HolderSet<Item>> createPrimaryItems() {
            HolderSet<Item> itemSet = this.primaryItems.isEmpty() && this.primaryItemsTag == null ? this.createSupportedItems() : this.createItemSet(this.primaryItemsTag, this.primaryItems);
            return Optional.of(itemSet);
        }

        private List<EquipmentSlotGroup> createSlots() {
            ArrayList<EquipmentSlotGroup> groups = new ArrayList<EquipmentSlotGroup>();
            for (org.bukkit.inventory.EquipmentSlotGroup slot : this.slots) {
                groups.add(EquipmentSlotGroup.valueOf((String)slot.toString().toUpperCase(Locale.ROOT)));
            }
            return groups;
        }

        public EnchantmentDefinition build() {
            Enchantment.EnchantmentDefinition definition = new Enchantment.EnchantmentDefinition(this.createSupportedItems(), this.createPrimaryItems(), Math.clamp((long)this.weight, 1, 1024), Math.clamp((long)this.maxLevel, 1, 255), new Enchantment.Cost(this.minCostBase, this.minCostPerLevelAboveFirst), new Enchantment.Cost(this.maxCostBase, this.maxCostPerLevelAboveFirst), this.anvilCost, this.createSlots());
            Component vanilla = PaperAdventure.asVanilla((net.kyori.adventure.text.Component)this.description);
            Enchantment enchantment = new Enchantment(vanilla, definition, this.createExclusiveSet(), DataComponentMap.EMPTY);
            TagData tagData = new TagData(this.isCursed, this.isTreasure, this.isTradeable, this.isDiscoverable, this.isOnRandomLoot, this.isOnMobSpawnEquipment, this.isOnTradedEquipment);
            return new EnchantmentDefinition(this.id, enchantment, tagData);
        }
    }
}

