/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class McUtils {
    private static final BlockData AIR = Material.AIR.createBlockData();

    private McUtils() {
    }

    @NotNull
    public static BlockPos getPos(@NotNull Location location) {
        return new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public static Vec3 getVec3(Location location) {
        return new Vec3(location.getX(), location.getY(), location.getZ());
    }

    @NotNull
    public static Direction getDirection(BlockFace blockFace) {
        if (blockFace == null) {
            return Direction.UP;
        }
        return switch (blockFace) {
            case BlockFace.DOWN -> Direction.DOWN;
            case BlockFace.NORTH -> Direction.NORTH;
            case BlockFace.SOUTH -> Direction.SOUTH;
            case BlockFace.EAST -> Direction.EAST;
            case BlockFace.WEST -> Direction.WEST;
            default -> Direction.UP;
        };
    }

    @NotNull
    public static Pair<ServerLevel, BlockPos> getLevelPos(@NotNull Location location) {
        BlockPos pos = McUtils.getPos(location);
        World bukkitWorld = location.getWorld();
        if (bukkitWorld == null) {
            throw new IllegalArgumentException("Missing world in location");
        }
        ServerLevel serverLevel = McUtils.getServerLevel(bukkitWorld);
        return new Pair((Object)serverLevel, (Object)pos);
    }

    @NotNull
    public static Location getLocation(BlockPos blockPos, Level level) {
        return new Location((World)level.getWorld(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    @NotNull
    public static ResourceLocation getResourceLocation(NamespacedKey bukkitKey) {
        return ResourceLocation.fromNamespaceAndPath((String)bukkitKey.getNamespace(), (String)bukkitKey.getKey());
    }

    @NotNull
    public static NamespacedKey getNamespacedKey(ResourceLocation resourceLocation) {
        return new NamespacedKey(resourceLocation.getNamespace(), resourceLocation.getPath());
    }

    @NotNull
    public static ServerLevel getServerLevel(@NotNull World world) {
        return ((CraftWorld)world).getHandle();
    }

    @Deprecated
    @NotNull
    public static WorldGenLevel getWorldGenLevel(@NotNull World world) {
        return McUtils.getServerLevel(world);
    }

    public static LevelChunk getLevelChunk(Chunk chunk) {
        ServerLevel serverLevel = McUtils.getServerLevel(chunk.getWorld());
        return serverLevel.getChunk(chunk.getX(), chunk.getZ());
    }

    public static <T> Registry<T> getRegistry(ResourceKey<? extends Registry<? extends T>> registry) {
        return MinecraftServer.getServer().registryAccess().lookupOrThrow(registry);
    }

    @NotNull
    public static ServerPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    public static net.minecraft.world.entity.Entity getNMSEntity(Entity bukkitEntity) {
        return ((CraftEntity)bukkitEntity).getHandle();
    }

    public static net.minecraft.world.entity.EntityType<?> getEntityType(EntityType bukkitType) {
        NamespacedKey key = bukkitType.getKey();
        ResourceLocation resourceLocation = McUtils.getResourceLocation(key);
        Optional ref = BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
        if (ref.isEmpty()) {
            throw new IllegalArgumentException("Unknown entity type " + String.valueOf(resourceLocation));
        }
        return (net.minecraft.world.entity.EntityType)((Holder.Reference)ref.get()).value();
    }

    @NotNull
    public static BlockData getBlockDataFromState(BlockState blockState) {
        CraftBlockData blockDataFromBlockState = CraftBlockData.fromData((BlockState)blockState);
        return blockDataFromBlockState != null ? blockDataFromBlockState : AIR;
    }

    @NotNull
    public static BlockState getBlockStateFromBlock(Block bukkitBlock) {
        return ((CraftBlock)bukkitBlock).getNMS();
    }

    @NotNull
    public static BlockState getBlockStateFromData(BlockData blockData) {
        return ((CraftBlockData)blockData).getState();
    }

    @Nullable
    public static <T> Holder.Reference<T> getHolderReference(Registry<T> registry, NamespacedKey key) {
        ResourceLocation resourceLocation = McUtils.getResourceLocation(key);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)resourceLocation);
        try {
            return registry.getOrThrow(resourceKey);
        }
        catch (IllegalStateException ignore) {
            return null;
        }
    }

    @Nullable
    public static <T> T getRegistryValue(Registry<T> registry, NamespacedKey key) {
        Holder.Reference<T> holderReference = McUtils.getHolderReference(registry, key);
        return (T)(holderReference != null ? holderReference.value() : null);
    }

    @NotNull
    public static <T> List<NamespacedKey> getRegistryKeys(Registry<T> registry) {
        ArrayList keys = new ArrayList();
        registry.keySet().forEach(resourceLocation -> {
            NamespacedKey namespacedKey = McUtils.getNamespacedKey(resourceLocation);
            keys.add(namespacedKey);
        });
        return keys.stream().sorted(Comparator.comparing(NamespacedKey::toString)).collect(Collectors.toList());
    }

    @NotNull
    public static BiomeResolver getBiomeResolver(MutableInt count, ChunkAccess chunkAccess, BoundingBox box, Holder<Biome> biome, Predicate<Holder<Biome>> filter) {
        return (x, y, z, noise) -> {
            Holder biomeHolder = chunkAccess.getNoiseBiome(x, y, z);
            if (box.isInside(x << 2, y << 2, z << 2) && filter.test(biomeHolder)) {
                count.increment();
                return biome;
            }
            return biomeHolder;
        };
    }

    public static void setSkin(GameProfile gameProfile) {
        try {
            URL url = new URI("https://sessionserver.mojang.com/session/minecraft/profile/" + gameProfile.getId().toString() + "?unsigned=false").toURL();
            InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
            JsonObject mainObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            if (mainObject == null) {
                Bukkit.getLogger().warning("[NMS-API] Skin cannot be fetched!");
                return;
            }
            JsonObject properties = mainObject.get("properties").getAsJsonArray().get(0).getAsJsonObject();
            String value = properties.get("value").getAsString();
            String signature = properties.get("signature").getAsString();
            PropertyMap propertyMap = gameProfile.getProperties();
            propertyMap.put((Object)"name", (Object)new Property("name", gameProfile.getName()));
            propertyMap.put((Object)"textures", (Object)new Property("textures", value, signature));
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static DedicatedServer getMinecraftServer(Server server) {
        return ((CraftServer)server).getServer();
    }

    @Nullable
    public static net.minecraft.network.chat.Component getNMSComponent(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return PaperAdventure.asVanilla((Component)Component.text((String)string));
        }
        if (object instanceof ComponentWrapper) {
            ComponentWrapper wrap = (ComponentWrapper)object;
            return PaperAdventure.asVanilla((Component)wrap.getComponent());
        }
        return null;
    }
}

