/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.util;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.util.Color;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ParticleUtils {
    private static final boolean HAS_TRAIL = Skript.classExists((String)"org.bukkit.Particle$Trail");
    private static final BlockData DEFAULT_DATA = Material.STONE.createBlockData();
    private static final ItemStack DEFAULT_ITEM = new ItemStack(Material.STONE);
    private static final Particle.DustOptions DEFAULT_DUST_OPTION = new Particle.DustOptions(org.bukkit.Color.RED, 1.0f);
    private static final Particle.DustTransition DEFAULT_DUST_TRANSITION = new Particle.DustTransition(org.bukkit.Color.RED, org.bukkit.Color.BLUE, 1.0f);
    private static final Vibration DEFAULT_VIBRATION = new Vibration((Vibration.Destination)new Vibration.Destination.BlockDestination(new Location((World)Bukkit.getWorlds().getFirst(), 1.0, 1.0, 1.0)), 1);
    private static final org.bukkit.Color DEFAULT_COLOR = org.bukkit.Color.RED;

    @Nullable
    public static Object getDataOrDefault(Particle particle, Object data) {
        Class dataType = particle.getDataType();
        if (dataType == Void.class) {
            return null;
        }
        if (dataType == Float.class) {
            if (data instanceof Number) {
                Number number = (Number)data;
                return Float.valueOf(number.floatValue());
            }
            return Float.valueOf(1.0f);
        }
        if (dataType == Integer.class) {
            if (data instanceof Number) {
                Number number = (Number)data;
                return number.intValue();
            }
            return 1;
        }
        if (dataType == ItemStack.class) {
            if (data instanceof ItemType) {
                ItemType itemType = (ItemType)data;
                return itemType.getRandom();
            }
            if (data instanceof ItemStack) {
                ItemStack is = (ItemStack)data;
                return is;
            }
            return DEFAULT_ITEM;
        }
        if (dataType == Particle.DustOptions.class) {
            if (data instanceof Particle.DustOptions) {
                Particle.DustOptions dustOptions = (Particle.DustOptions)data;
                return dustOptions;
            }
            return DEFAULT_DUST_OPTION;
        }
        if (dataType == Particle.DustTransition.class) {
            if (data instanceof Particle.DustTransition) {
                Particle.DustTransition dustTransition = (Particle.DustTransition)data;
                return dustTransition;
            }
            return DEFAULT_DUST_TRANSITION;
        }
        if (dataType == Vibration.class) {
            if (data instanceof Vibration) {
                Vibration vibration = (Vibration)data;
                return vibration;
            }
            return DEFAULT_VIBRATION;
        }
        if (dataType == org.bukkit.Color.class) {
            if (data instanceof Color) {
                Color skriptColor = (Color)data;
                return skriptColor.asBukkitColor();
            }
            if (data instanceof org.bukkit.Color) {
                org.bukkit.Color color = (org.bukkit.Color)data;
                return color;
            }
            return DEFAULT_COLOR;
        }
        if (dataType == BlockData.class) {
            ItemType itemType;
            Material material;
            if (data instanceof BlockData) {
                return data;
            }
            if (data instanceof ItemType && (material = (itemType = (ItemType)data).getMaterial()).isBlock()) {
                return material.createBlockData();
            }
            return DEFAULT_DATA;
        }
        if (HAS_TRAIL && dataType == Particle.Trail.class && data instanceof Particle.Trail) {
            return data;
        }
        return null;
    }
}

