/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.util;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.registry.RegistryParser;
import ch.njol.skript.registrations.Classes;
import com.shanebeestudios.nms.api.registry.BiomeDefinition;
import com.shanebeestudios.nms.api.registry.EnchantmentDefinition;
import com.shanebeestudios.skbee.api.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryUtils {
    private static final MinecraftServer SERVER = MinecraftServer.getServer();
    private static final Registry<Enchantment> ENCHANT_REGISTRY = RegistryUtils.getRegistry(Registries.ENCHANTMENT);
    private static final Registry<Item> ITEM_REGISTRY = RegistryUtils.getRegistry(Registries.ITEM);
    private static final Registry<net.minecraft.world.level.biome.Biome> BIOME_REGISTRY = RegistryUtils.getRegistry(Registries.BIOME);
    private static final Registry<PlacedFeature> PLACED_FEATURE_REGISTRY = RegistryUtils.getRegistry(Registries.PLACED_FEATURE);
    private static final Registry<Dialog> DIALOG_REGISTRY = RegistryUtils.getRegistry(Registries.DIALOG);

    public static Registry<Enchantment> getEnchantRegistry() {
        return ENCHANT_REGISTRY;
    }

    public static Registry<Item> getItemRegistry() {
        return ITEM_REGISTRY;
    }

    public static Registry<net.minecraft.world.level.biome.Biome> getBiomeRegistry() {
        return BIOME_REGISTRY;
    }

    public static Registry<Dialog> getDialogRegistry() {
        return DIALOG_REGISTRY;
    }

    @NotNull
    public static <T> ResourceKey<T> getResourceKey(@NotNull Registry<T> registry, @NotNull String name) {
        return ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.parse((String)name));
    }

    public static <T> ResourceLocation getResourceLocation(@NotNull NamespacedKey namespacedKey) {
        return CraftNamespacedKey.toMinecraft((NamespacedKey)namespacedKey);
    }

    @Nullable
    public static <T> TagKey<T> getTagKey(@NotNull Registry<T> registry, @NotNull String name) {
        TagKey tagKey = TagKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.parse((String)name));
        if (registry.get(tagKey).isPresent()) {
            return tagKey;
        }
        return null;
    }

    @NotNull
    private static <T> Map<TagKey<T>, HolderSet.Named<T>> getFrozenTags(@NotNull Registry<T> registry) {
        return (Map)ReflectionUtils.getField((String)"frozenTags", (Class)registry.getClass(), registry);
    }

    @NotNull
    private static <T> Object getAllTags(@NotNull Registry<T> registry) {
        return ReflectionUtils.getField((String)"allTags", MappedRegistry.class, registry);
    }

    @NotNull
    private static <T> Map<TagKey<T>, HolderSet.Named<T>> getTagsMap(@NotNull Object tagSet) {
        return new HashMap<TagKey<T>, HolderSet.Named<T>>((Map)ReflectionUtils.getField((String)"val$map", tagSet.getClass(), (Object)tagSet));
    }

    public static <T> void unfreeze(@NotNull Registry<T> registry) {
        ReflectionUtils.setField((String)"frozen", registry, (Object)false);
        ReflectionUtils.setField((String)"unregisteredIntrusiveHolders", registry, new IdentityHashMap());
    }

    public static <T> void freeze(@NotNull Registry<T> registry) {
        Object tagSet = RegistryUtils.getAllTags(registry);
        Map<TagKey<T>, HolderSet.Named<T>> tagsMap = RegistryUtils.getTagsMap(tagSet);
        Map<TagKey<T>, HolderSet.Named<T>> frozenTags = RegistryUtils.getFrozenTags(registry);
        tagsMap.forEach(frozenTags::putIfAbsent);
        RegistryUtils.unbound(registry);
        registry.freeze();
        frozenTags.forEach(tagsMap::putIfAbsent);
        ReflectionUtils.setField((String)"val$map", tagSet.getClass(), (Object)tagSet, tagsMap);
        ReflectionUtils.setField((String)"allTags", (Class)registry.getClass(), registry, (Object)tagSet);
    }

    private static <T> void unbound(@NotNull Registry<T> registry) {
        Class tagSetClass = ReflectionUtils.getNMSClass((String)"net.minecraft.core.MappedRegistry$TagSet");
        try {
            Method unbound = tagSetClass.getMethod("unbound", new Class[0]);
            unbound.setAccessible(true);
            Object unboundTagSet = unbound.invoke(registry, new Object[0]);
            ReflectionUtils.setField((String)"allTags", registry, (Object)unboundTagSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T> void addInTag(@NotNull TagKey<T> tagKey, @NotNull Holder.Reference<T> reference) {
        Registry<T> registry = RegistryUtils.getRegistry(tagKey.registry());
        RegistryUtils.modifyTag(registry, tagKey, reference, List::add);
    }

    private static <T> void removeFromTag(@NotNull TagKey<T> tagKey, @NotNull Holder.Reference<T> reference) {
        Registry<T> registry = RegistryUtils.getRegistry(tagKey.registry());
        RegistryUtils.modifyTag(registry, tagKey, reference, List::remove);
    }

    private static <T> void modifyTag(@NotNull Registry<T> registry, @NotNull TagKey<T> tagKey, @NotNull Holder.Reference<T> reference, @NotNull BiConsumer<List<Holder<T>>, Holder.Reference<T>> consumer) {
        HolderSet.Named holders = registry.get(tagKey).orElse(null);
        if (holders == null) {
            return;
        }
        ArrayList contents = new ArrayList(holders.stream().toList());
        consumer.accept(contents, reference);
        if (registry instanceof MappedRegistry) {
            MappedRegistry mappedRegistry = (MappedRegistry)registry;
            mappedRegistry.bindTag(tagKey, contents);
        }
    }

    private static void setupBiomeDistribution(@NotNull Holder.Reference<net.minecraft.world.level.biome.Biome> reference, BiomeDefinition definition) {
        definition.getTagKeys().forEach(tag -> RegistryUtils.addInTag(tag, reference));
    }

    private static void setupDistribution(@NotNull Holder.Reference<Enchantment> reference, EnchantmentDefinition distribution) {
        boolean experimentalTrades = SERVER.getWorldData().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE);
        EnchantmentDefinition.TagData tagData = distribution.getTagData();
        if (tagData.isTradeable) {
            RegistryUtils.addInTag(EnchantmentTags.TREASURE, reference);
            RegistryUtils.addInTag(EnchantmentTags.DOUBLE_TRADE_PRICE, reference);
        } else {
            RegistryUtils.addInTag(EnchantmentTags.NON_TREASURE, reference);
        }
        if (tagData.isOnRandomLoot) {
            RegistryUtils.addInTag(EnchantmentTags.ON_RANDOM_LOOT, reference);
        }
        if (!tagData.isTreasure) {
            if (tagData.isOnMobSpawnEquipment) {
                RegistryUtils.addInTag(EnchantmentTags.ON_MOB_SPAWN_EQUIPMENT, reference);
            }
            if (tagData.isOnTradedEquipment) {
                RegistryUtils.addInTag(EnchantmentTags.ON_TRADED_EQUIPMENT, reference);
            }
        }
        if (experimentalTrades) {
            if (tagData.isTradeable) {
                RegistryUtils.addInTag(EnchantmentTags.TRADES_DESERT_COMMON, reference);
                RegistryUtils.addInTag(EnchantmentTags.TRADES_JUNGLE_COMMON, reference);
            }
        } else if (tagData.isTradeable) {
            RegistryUtils.addInTag(EnchantmentTags.TRADEABLE, reference);
        } else {
            RegistryUtils.removeFromTag(EnchantmentTags.TRADEABLE, reference);
        }
        if (tagData.isCursed) {
            RegistryUtils.addInTag(EnchantmentTags.CURSE, reference);
        } else if (!tagData.isTreasure) {
            if (tagData.isDiscoverable) {
                RegistryUtils.addInTag(EnchantmentTags.IN_ENCHANTING_TABLE, reference);
            } else {
                RegistryUtils.removeFromTag(EnchantmentTags.IN_ENCHANTING_TABLE, reference);
            }
        }
    }

    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> key) {
        return (Registry)MinecraftServer.getServer().registryAccess().lookup(key).orElseThrow();
    }

    public static org.bukkit.enchantments.Enchantment registerEnchantment(EnchantmentDefinition definition) {
        RegistryUtils.unfreeze(ENCHANT_REGISTRY);
        ResourceLocation key = CraftNamespacedKey.toMinecraft((NamespacedKey)definition.getId());
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)key);
        Enchantment enchantment = definition.getEnchantment();
        Holder.Reference intrusiveHolder = ENCHANT_REGISTRY.createIntrusiveHolder((Object)enchantment);
        Registry.register(ENCHANT_REGISTRY, (ResourceKey)resourceKey, (Object)enchantment);
        RegistryUtils.setupDistribution((Holder.Reference<Enchantment>)intrusiveHolder, definition);
        RegistryUtils.freeze(ENCHANT_REGISTRY);
        RegistryUtils.refreshSkriptRegistry(org.bukkit.enchantments.Enchantment.class);
        return CraftEnchantment.minecraftToBukkit((Enchantment)enchantment);
    }

    public static Biome registerBiome(BiomeDefinition definition) {
        RegistryUtils.unfreeze(BIOME_REGISTRY);
        ResourceLocation key = definition.getKey();
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)key);
        net.minecraft.world.level.biome.Biome biome = definition.getBiome();
        Holder.Reference intrusiveHolder = BIOME_REGISTRY.createIntrusiveHolder((Object)biome);
        Registry.register(BIOME_REGISTRY, (ResourceKey)resourceKey, (Object)biome);
        RegistryUtils.setupBiomeDistribution((Holder.Reference<net.minecraft.world.level.biome.Biome>)intrusiveHolder, definition);
        RegistryUtils.freeze(BIOME_REGISTRY);
        RegistryUtils.refreshSkriptRegistry(Biome.class);
        return CraftBiome.minecraftToBukkit((net.minecraft.world.level.biome.Biome)biome);
    }

    public static void registerDialog(Dialog dialog, NamespacedKey dialogKey) {
        ResourceLocation key = CraftNamespacedKey.toMinecraft((NamespacedKey)dialogKey);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DIALOG, (ResourceLocation)key);
        if (DIALOG_REGISTRY.containsKey(resourceKey)) {
            return;
        }
        RegistryUtils.unfreeze(DIALOG_REGISTRY);
        Holder.Reference intrusiveHolder = DIALOG_REGISTRY.createIntrusiveHolder((Object)dialog);
        Registry.register(DIALOG_REGISTRY, (ResourceKey)resourceKey, (Object)dialog);
        RegistryUtils.freeze(DIALOG_REGISTRY);
    }

    public static Holder<PlacedFeature> getFeature(NamespacedKey key) {
        ResourceLocation resourceLocation = RegistryUtils.getResourceLocation(key);
        return PLACED_FEATURE_REGISTRY.get(resourceLocation).orElse(null);
    }

    public static <T> void refreshSkriptRegistry(Class<T> registryClass) {
        ClassLoader classLoader = Skript.class.getClassLoader();
        boolean assertionStatus = Skript.class.desiredAssertionStatus();
        classLoader.setClassAssertionStatus(Skript.class.getName(), false);
        ClassInfo classInfo = Classes.getExactClassInfo(registryClass);
        Parser parser = classInfo.getParser();
        try {
            Method refresh = RegistryParser.class.getDeclaredMethod("refresh", new Class[0]);
            refresh.setAccessible(true);
            refresh.invoke((Object)parser, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        classLoader.setClassAssertionStatus(Skript.class.getName(), assertionStatus);
    }
}

