/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.world;

import com.mojang.datafixers.util.Pair;
import com.shanebeestudios.nms.api.util.McUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldApi {
    private static final Registry<Biome> BIOME_REGISTRY = McUtils.getRegistry(Registries.BIOME);

    private WorldApi() {
    }

    @NotNull
    public static NamespacedKey getBiome(@NotNull Location location) {
        int z;
        int y;
        int x;
        ServerLevel serverLevel = (ServerLevel)McUtils.getLevelPos(location).getFirst();
        Biome biome = (Biome)serverLevel.getNoiseBiome((x = location.getBlockX()) >> 2, (y = location.getBlockY()) >> 2, (z = location.getBlockZ()) >> 2).value();
        ResourceLocation key = BIOME_REGISTRY.getKey((Object)biome);
        if (key == null) {
            key = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"plains");
        }
        return McUtils.getNamespacedKey(key);
    }

    public static void setBiome(@NotNull Location location, @NotNull NamespacedKey biomeKey) {
        ServerLevel serverLevel = (ServerLevel)McUtils.getLevelPos(location).getFirst();
        Holder.Reference<Biome> biome = McUtils.getHolderReference(BIOME_REGISTRY, biomeKey);
        if (biome == null) {
            return;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        LevelChunk chunk = serverLevel.getChunkAt(new BlockPos(x, y, z));
        chunk.setBiome(x >> 2, y >> 2, z >> 2, biome);
        chunk.markUnsaved();
    }

    public static void fillBiome(@NotNull Location location, @NotNull Location location2, @NotNull NamespacedKey biomeKey) {
        WorldApi.fillBiome(location, location2, biomeKey, null);
    }

    public static void fillBiome(@NotNull Location location, @NotNull Location location2, @NotNull NamespacedKey biomeKey, @Nullable NamespacedKey replaceKey) {
        ResourceLocation replaceBiome;
        World world = location.getWorld();
        if (world != location2.getWorld()) {
            throw new IllegalArgumentException("Worlds for both locations do not match!");
        }
        BlockPos blockPos = McUtils.getPos(location);
        BlockPos blockPos2 = McUtils.getPos(location2);
        BoundingBox box = BoundingBox.fromCorners((Vec3i)blockPos, (Vec3i)blockPos2);
        ServerLevel level = McUtils.getServerLevel(world);
        Holder.Reference<Biome> biome = McUtils.getHolderReference(BIOME_REGISTRY, biomeKey);
        ResourceLocation resourceLocation = replaceBiome = replaceKey != null ? McUtils.getResourceLocation(replaceKey) : null;
        if (biome == null) {
            return;
        }
        ArrayList<ChunkAccess> chunkAccessList = new ArrayList<ChunkAccess>();
        for (int z = SectionPos.blockToSectionCoord((int)box.minZ()); z <= SectionPos.blockToSectionCoord((int)box.maxZ()); ++z) {
            for (int x = SectionPos.blockToSectionCoord((int)box.minX()); x <= SectionPos.blockToSectionCoord((int)box.maxX()); ++x) {
                ChunkAccess chunkAccess = level.getChunk(x, z, ChunkStatus.FULL, false);
                if (chunkAccess == null) continue;
                chunkAccessList.add(chunkAccess);
            }
        }
        for (ChunkAccess chunkAccess : chunkAccessList) {
            chunkAccess.fillBiomesFromNoise(McUtils.getBiomeResolver(new MutableInt(0), chunkAccess, box, biome, biomeHolder -> replaceBiome == null || biomeHolder.is(replaceBiome)), level.getChunkSource().randomState().sampler());
            chunkAccess.markUnsaved();
        }
        level.getChunkSource().chunkMap.resendBiomesForChunks(chunkAccessList);
    }

    @Nullable
    public static Location locateBiome(@NotNull NamespacedKey biomeKey, @NotNull Location center) {
        return WorldApi.locateBiome(biomeKey, center, 6400, 8);
    }

    @Nullable
    public static Location locateBiome(@NotNull NamespacedKey biomeKey, @NotNull Location center, int radius, int step) {
        ResourceLocation resourceLocation;
        Pair<ServerLevel, BlockPos> levelPos = McUtils.getLevelPos(center);
        BlockPos blockPos = (BlockPos)levelPos.getSecond();
        ServerLevel level = (ServerLevel)levelPos.getFirst();
        Pair closestBiome3d = level.findClosestBiome3d(arg_0 -> WorldApi.lambda$locateBiome$1(resourceLocation = McUtils.getResourceLocation(biomeKey), arg_0), blockPos, radius, step, 64);
        if (closestBiome3d == null) {
            return null;
        }
        BlockPos biomePos = (BlockPos)closestBiome3d.getFirst();
        return McUtils.getLocation(biomePos, (Level)level);
    }

    @NotNull
    public static List<NamespacedKey> getBiomeKeys() {
        return McUtils.getRegistryKeys(BIOME_REGISTRY);
    }

    public static boolean isWithinVillage(Location location) {
        World world = location.getWorld();
        if (world != null) {
            ServerLevel serverLevel = McUtils.getServerLevel(world);
            BlockPos blockPos = McUtils.getPos(location);
            return serverLevel.isVillage(blockPos);
        }
        return false;
    }

    public static void fillBlocks(@NotNull Location location, @NotNull Location location2, @NotNull BlockData data, @Nullable BlockData replace) {
        World world = location.getWorld();
        if (world != location2.getWorld()) {
            throw new IllegalArgumentException("Worlds for both locations need to match.");
        }
        BlockPos blockPos = McUtils.getPos(location);
        BlockPos blockPos2 = McUtils.getPos(location2);
        ServerLevel level = McUtils.getServerLevel(world);
        BlockState changeTo = McUtils.getBlockStateFromData(data);
        Set<Property> properties = Set.of(changeTo.getProperties().toArray(new Property[0]));
        BlockState toReplace = replace != null ? McUtils.getBlockStateFromData(replace) : null;
        ArrayList<LevelChunk> chunks = new ArrayList<LevelChunk>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos, (BlockPos)blockPos2)) {
            LevelChunk chunkAt = level.getChunkAt(pos);
            if (!chunks.contains(chunkAt)) {
                chunks.add(chunkAt);
            }
            BlockPos newPos = new BlockPos(pos.getX() - (chunkAt.locX << 4), pos.getY(), pos.getZ() - (chunkAt.locZ << 4));
            if (toReplace != null && chunkAt.getBlockState(newPos).getBlock() != toReplace.getBlock()) continue;
            chunkAt.removeBlockEntity(newPos);
            chunkAt.setBlockState(newPos, changeTo, 3);
        }
        for (LevelChunk chunk : chunks) {
            world.refreshChunk(chunk.locX, chunk.locZ);
        }
    }

    private static /* synthetic */ boolean lambda$locateBiome$1(ResourceLocation resourceLocation, Holder holder) {
        return holder.is(resourceLocation);
    }
}

