/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.registry.BiomeDefinition;
import com.shanebeestudios.nms.elements.sections.SecBiomeRegister;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Apply Biome Definition Spawner")
@Description(value={"Create a spawner entry for the `spawners` section of a biome registration.", "See [**Biome Definition**](https://minecraft.wiki/w/Biome_definition) on McWiki for more details.", "`minecraftentitytypes` = The type of entity to spawn (This is from SkBee).", "`weight`` = How often this mob should spawn, higher values produce more spawns.", "`min count` = The minimum count of mobs to spawn in a pack. Must be greater than 0 (optional, defaults to 1).", "`max count` = The maximum count of mobs to spawn in a pack. Must be greater than 0 (optional, defaults to min count)."})
@Examples(value={"spawners:", "\tcreature:", "\t\tapply spawner for sheep with weight 12 and with min count 4", "\tmonster:", "\t\tapply spawner for illusioner with weight 1 and with min count 1", "\t\tapply spawner for zombie, skeleton and creeper with weight 3 and with min count 1"})
@Since(value={"1.1.0"})
public class EffApplyBiomeSpawner
extends Effect {
    private Expression<EntityType> entityType;
    private Expression<Integer> weight;
    private Expression<Integer> minCount;
    private Expression<Integer> maxCount;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityType = exprs[0];
        this.weight = exprs[1];
        this.minCount = exprs[2];
        this.maxCount = exprs[3];
        return true;
    }

    protected void execute(Event event) {
        if (!(event instanceof SecBiomeRegister.BiomeEffectsEvent)) {
            return;
        }
        SecBiomeRegister.BiomeEffectsEvent biomeEffectsEvent = (SecBiomeRegister.BiomeEffectsEvent)event;
        int weight = (Integer)this.weight.getSingle(event);
        int minCount = this.minCount != null ? this.minCount.getOptionalSingle(event).orElse(1) : 1;
        int maxCount = this.maxCount != null ? this.maxCount.getOptionalSingle(event).orElse(minCount) : minCount;
        int step = biomeEffectsEvent.getStep();
        BiomeDefinition.Builder builder = biomeEffectsEvent.getBiomeBuilder();
        for (EntityType type : (EntityType[])this.entityType.getArray(event)) {
            builder.addMobSpawn(step, type, weight, minCount, maxCount);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(event, debug);
        builder.append(new Object[]{"apply spawner for", this.entityType});
        builder.append(new Object[]{"with weight", this.weight});
        if (this.minCount != null) {
            builder.append(new Object[]{"with min count", this.minCount});
        }
        if (this.maxCount != null) {
            builder.append(new Object[]{"with max count", this.maxCount});
        }
        return builder.toString();
    }

    static {
        Skript.registerEffect(EffApplyBiomeSpawner.class, (String[])new String[]{"apply spawner (of|for) %minecraftentitytypes% with weight [of] %integer% [[and] with min count %-integer% [[and] max count %-integer%]]"});
    }
}

