/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.util.McUtils;
import com.shanebeestudios.nms.api.util.RegistryUtils;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Dialog - Open Dialog")
@Description(value={"Open a dialog to players.", "You can use keys from your own custom dialogs, as well as dialogs from DataPacks."})
@Examples(value={"open dialog with id \"minecraft:my_dialog\" to player", "open dialog with id \"my_pack:some_dialog\" to all players"})
@Since(value={"1.3.0"})
public class EffOpenDialog
extends Effect {
    private Expression<?> id;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.id = exprs[0];
        this.players = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        NamespacedKey key;
        Object singleId = this.id.getSingle(event);
        if (singleId instanceof String) {
            String string = (String)singleId;
            key = NamespacedKey.fromString((String)string);
        } else if (singleId instanceof NamespacedKey) {
            NamespacedKey nsk;
            key = nsk = (NamespacedKey)singleId;
        } else {
            return;
        }
        if (key == null) {
            return;
        }
        ResourceLocation resourceLocation = McUtils.getResourceLocation(key);
        Optional dialogReference = RegistryUtils.getDialogRegistry().get(resourceLocation);
        Holder dialogHolder = dialogReference.orElse(null);
        if (dialogHolder == null) {
            return;
        }
        for (Player player : (Player[])this.players.getArray(event)) {
            ServerPlayer serverPlayer = McUtils.getServerPlayer(player);
            serverPlayer.openDialog(dialogHolder);
        }
    }

    public String toString(@Nullable Event e, boolean d) {
        return new SyntaxStringBuilder(e, d).append(new Object[]{"open dialog with id", this.id}).append(new Object[]{"to", this.players}).toString();
    }

    static {
        Skript.registerEffect(EffOpenDialog.class, (String[])new String[]{"open dialog with id %string/namespacedkey% to %players%"});
    }
}

