/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.world.StructureApi;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Available Object Keys")
@Description(value={"Get a list of available NamespacedKeys for different Minecraft objects.", "**NOTES**:", "- `structure` = A structure like an entire village.", "- `structure template` = A structure piece like an individual house in a village."})
@Examples(value={"send all available biome keys", "set {_keys::*} to all available structure keys"})
@Since(value={"1.0.0"})
public class ExprAvailableKeys
extends SimpleExpression<NamespacedKey> {
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        return true;
    }

    @Nullable
    protected NamespacedKey[] get(Event event) {
        List<NamespacedKey> keys = switch (this.pattern) {
            case 0 -> StructureApi.getConfiguredFeatures();
            case 1 -> StructureApi.getPlacedFeatures();
            case 2 -> StructureApi.getStructures();
            case 3 -> StructureApi.getStructureTemplates();
            default -> throw new IllegalStateException("Unexpected value: " + this.pattern);
        };
        return keys.toArray(new NamespacedKey[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends NamespacedKey> getReturnType() {
        return NamespacedKey.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "available " + (switch (this.pattern) {
            case 0 -> "configured feature keys";
            case 1 -> "placed feature keys";
            case 2 -> "structure keys";
            case 3 -> "structure template keys";
            default -> throw new IllegalStateException("Unexpected value: " + this.pattern);
        });
    }

    static {
        Skript.registerExpression(ExprAvailableKeys.class, NamespacedKey.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all] available configured feature keys", "[all] available placed feature keys", "[all] available structure keys", "[all] available structure template keys"});
    }
}

