/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.world.BlockApi;
import java.util.ArrayList;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockData for Placement")
@Description(value={"Get the BlockData as if a player were to place a block.", "**Options**:", "- `using %itemtype%` = Check for a specific item. If excluded, will default to the player's held item."})
@Examples(value={"set {_data} to blockdata for placement of player", "set {_data} to blockdata for placement of player using oak stairs"})
@Since(value={"1.0.0"})
public class ExprBlockDataForPlacement
extends SimpleExpression<BlockData> {
    private static final int DEFAULT_DISTANCE = (Integer)SkriptConfig.maxTargetBlockDistance.value();
    private Expression<Player> players;
    private Expression<ItemType> itemType;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.itemType = exprs[1];
        return true;
    }

    @Nullable
    protected BlockData[] get(Event event) {
        ItemType itemType;
        ArrayList<BlockData> blockDataList = new ArrayList<BlockData>();
        ItemStack itemStack = null;
        if (this.itemType != null && (itemType = (ItemType)this.itemType.getSingle(event)) != null) {
            itemStack = itemType.getRandom();
        }
        for (Player player : (Player[])this.players.getArray(event)) {
            BlockData blockData = itemStack != null ? BlockApi.getBlockDataForPlacement(player, DEFAULT_DISTANCE, itemStack) : BlockApi.getBlockDataForPlacement(player, DEFAULT_DISTANCE);
            blockDataList.add(blockData);
        }
        return blockDataList.toArray(new BlockData[0]);
    }

    public boolean isSingle() {
        return this.players.isSingle();
    }

    @NotNull
    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String using = this.itemType != null ? " using " + this.itemType.toString(e, d) : "";
        return "blockdata for placement of " + this.players.toString(e, d) + using;
    }

    static {
        Skript.registerExpression(ExprBlockDataForPlacement.class, BlockData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"block[ ]data for placement (of|from) %players% [using %-itemtype%]"});
    }
}

