/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.registry.BiomeDefinition;
import com.shanebeestudios.nms.api.skript.RegistrationSection;
import com.shanebeestudios.nms.elements.structures.StructRegistryRegistration;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.SectionEntryData;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Biome Definition Registration")
@Description(value={"Register a new biome.", "NOTE: These custom biomes will NOT show up in natural world generation.", "See [**Biome Definition**](https://minecraft.wiki/w/Biome_definition) on McWiki for more details.", "See more examples on the [**SkNMS Wiki**](https://github.com/ShaneBeee/SkNMS/wiki/Custom-Biomes).", "", "**Entries/Sections**:", "- `has_precipitation` = Determines whether or not the biome has precipitation.", "- `temperature` = Controls gameplay features like grass and foliage color, and a height adjusted temperature (which controls whether raining or snowing if `has precipitation` is true, and generation details of some features).", "- `downfall` = Controls grass and foliage color.", "- `effects` = A section to add special effects to a biome (see Biome Effects section).", "- `features` = A section to apply different [**Placed Features**](https://minecraft.wiki/w/Placed_feature) that will apply during chunk generation. See the Biome Features section and Apply Biome Features effect for more information.", "- `spawners` = A section to determine which mobs spawn in this biome (See the biome spawners section and apply biome spawner effect for more information).", "- `tags` = A section to specify which biome tags you would like to include your biome in."})
@Examples(value={"registry registration:", "\tregister new biome:", "\t\tid: \"my_biomes:blue_forest\"", "\t\thas_precipitation: true", "\t\ttemperature: 2.0", "\t\tdownfall: 1.0", "\t\teffects:", "\t\t\tfog_color: rgb(240,227,159)", "\t\t\twater_color: rgb(159,240,215)", "\t\t\twater_fog_color: rgb(159,240,215)", "\t\t\tsky_color: rgb(159,226,240)", "\t\t\tfoliage_color: yellow", "\t\t\tgrass_color: blue"})
@Since(value={"1.0.0"})
public class SecBiomeRegister
extends RegistrationSection {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private Expression<?> id;
    private Expression<Boolean> hasPrecipitation;
    private Expression<Number> temperature;
    private Expression<Number> downfall;
    private Section effects;
    private Trigger features;
    private Trigger spawners;
    private Trigger tags;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        SectionNode tagsNode;
        SectionNode spawnersNode;
        if (!this.getParser().isCurrentStructure(StructRegistryRegistration.class)) {
            Skript.error((String)"Biomes can only be registered in a 'registry registration' structure");
            return false;
        }
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.id = (Expression)container.getOptional("id", false);
        this.hasPrecipitation = (Expression)container.getOptional("has_precipitation", false);
        this.temperature = (Expression)container.getOptional("temperature", false);
        this.downfall = (Expression)container.getOptional("downfall", false);
        for (Node node : container.getUnhandledNodes()) {
            SectionNode secNode;
            if (!(node instanceof SectionNode) || !(secNode = (SectionNode)node).getKey().equals("effects")) continue;
            Class[] currentEvents = this.getParser().getCurrentEvents();
            this.getParser().setCurrentEvent("effects section", new Class[]{BiomeEffectsEvent.class});
            this.effects = Section.parse((String)node.getKey(), (String)("Invalid Section: " + node.getKey()), (SectionNode)secNode, null);
            this.getParser().setCurrentEvents(currentEvents);
        }
        SectionNode featuresNode = (SectionNode)container.getOptional("features", false);
        if (featuresNode != null) {
            this.features = this.loadCode(featuresNode, "features", new Class[]{BiomeEffectsEvent.class});
        }
        if ((spawnersNode = (SectionNode)container.getOptional("spawners", false)) != null) {
            this.spawners = this.loadCode(spawnersNode, "spawners", new Class[]{BiomeEffectsEvent.class});
        }
        if ((tagsNode = (SectionNode)container.getOptional("tags", false)) != null) {
            this.tags = this.loadCode(tagsNode, "tags", new Class[]{BiomeEffectsEvent.class});
        }
        return this.id != null && this.hasPrecipitation != null && this.temperature != null && this.downfall != null;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        NamespacedKey key;
        TriggerItem next = this.getNext();
        Object single = this.id.getSingle(event);
        Boolean hasPrecipitation = (Boolean)this.hasPrecipitation.getSingle(event);
        Number temperature = (Number)this.temperature.getSingle(event);
        Number downfall = (Number)this.downfall.getSingle(event);
        if (single == null || hasPrecipitation == null || temperature == null || downfall == null) {
            return null;
        }
        if (single instanceof NamespacedKey) {
            NamespacedKey nsk;
            v0 = nsk = (NamespacedKey)single;
        } else if (single instanceof String) {
            String s = (String)single;
            v0 = NamespacedKey.fromString((String)s);
        } else {
            v0 = key = null;
        }
        if (key == null) {
            this.error("ID is invalid, no biome created: " + this.id.toString(event, true));
            return null;
        }
        Biome biome = (Biome)Registry.BIOME.get(key);
        if (biome != null) {
            return next;
        }
        BiomeDefinition.Builder builder = new BiomeDefinition.Builder(key);
        builder.hasPrecipitation(hasPrecipitation);
        builder.temperature(temperature.floatValue());
        builder.downfall(downfall.floatValue());
        if (this.effects != null) {
            Section.walk((TriggerItem)this.effects, (Event)new BiomeEffectsEvent(builder));
        }
        if (this.features != null) {
            Trigger.walk((TriggerItem)this.features, (Event)new BiomeEffectsEvent(builder));
        }
        if (this.spawners != null) {
            Trigger.walk((TriggerItem)this.spawners, (Event)new BiomeEffectsEvent(builder));
        }
        if (this.tags != null) {
            Trigger.walk((TriggerItem)this.tags, (Event)new BiomeEffectsEvent(builder));
        }
        builder.build().register();
        return next;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "register new biome";
    }

    static {
        Class[] idClasses = new Class[]{String.class, NamespacedKey.class};
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("id", null, false, idClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("has_precipitation", null, false, Boolean.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("temperature", null, false, Number.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("downfall", null, false, Number.class));
        VALIDATOR.addEntryData((EntryData)new SectionEntryData("features", null, true));
        VALIDATOR.addEntryData((EntryData)new SectionEntryData("spawners", null, true));
        VALIDATOR.addEntryData((EntryData)new SectionEntryData("tags", null, true));
        if (Bukkit.getPluginManager().getPlugin("SkriptHubDocsTool") != null) {
            VALIDATOR.addEntryData((EntryData)new SectionEntryData("effects", null, true));
        } else {
            VALIDATOR.unexpectedNodeTester(node -> {
                if (node instanceof SectionNode) {
                    SectionNode sectionNode = (SectionNode)node;
                    String key = sectionNode.getKey();
                    return key == null || !key.contains("effects");
                }
                return true;
            });
        }
        Skript.registerSection(SecBiomeRegister.class, (String[])new String[]{"register [new] [custom] biome"});
    }

    public static class BiomeEffectsEvent
    extends Event {
        private final BiomeDefinition.Builder builder;
        private int step = 0;

        public BiomeEffectsEvent(BiomeDefinition.Builder builder) {
            this.builder = builder;
        }

        public BiomeDefinition.Builder getBiomeBuilder() {
            return this.builder;
        }

        public int getStep() {
            return this.step;
        }

        public void setStep(int step) {
            this.step = step;
        }

        @NotNull
        public HandlerList getHandlers() {
            throw new IllegalStateException("This event should never be called!");
        }
    }
}

