/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Color;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.registry.BiomeDefinition;
import com.shanebeestudios.nms.api.registry.ParticleOption;
import com.shanebeestudios.nms.elements.sections.SecBiomeRegister;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="Biome Definition Effects")
@Description(value={"Create effects in a biome registration `effects` section.", "See [**Biome Definition**](https://minecraft.wiki/w/Biome_definition) on McWiki for more details.", "See more examples on the [**SkNMS Wiki**](https://github.com/ShaneBeee/SkNMS/wiki/Custom-Biomes).", "**Entries**:", "All color entries accept Skript colors, RGB colors as well as integers (Refer to the above wiki to see information about the integers).", "- `fog_color` = The color of fog in this biome (required).", "- `sky_color` = The color of the sky in this biome (required).", "- `water_color` = The color of the water in this biome (required).", "- `water_fog_color` = The color of the fog when underwater in this biome (required).", "- `foliage_color` = The color to use for tree leaves and vines. If not present, the value depends on downfall and temperature (optional).", "- `dry_foliage_color` = The color used for tinting blocks using dry foliage tinting.", "- `grass_color` = The color to use for grass blocks, short grass, tall grass, ferns, tall ferns, and sugar cane. If not present, the value depends on downfall and temperature (optional).", "- `grass_color_modifier` = Built in color modifier for grass blocks (Can be `none`, `dark_forest` or `swamp`).", "- `particle` = Add a particle to use throughout this biome. Accepts a ParticleOption."})
@Examples(value={"registry registration:", "\tregister new biome:", "\t\tid: \"my_biomes:blue_forest\"", "\t\thas_precipitation: true", "\t\ttemperature: 2.0", "\t\tdownfall: 1.0", "\t\teffects:", "\t\t\tfog_color: rgb(240,227,159)", "\t\t\twater_color: rgb(159,240,215)", "\t\t\twater_fog_color: rgb(159,240,215)", "\t\t\tsky_color: rgb(159,226,240)", "\t\t\tfoliage_color: yellow", "\t\t\tdrt_foliage_color: rgb(249,171,123)", "\t\t\tgrass_color: blue"})
@Since(value={"1.0.0"})
public class SecBiomeSpecialEffects
extends Section {
    private static final EntryValidator VALIDATOR;
    private Expression<?> fogColor;
    private Expression<?> skyColor;
    private Expression<?> waterColor;
    private Expression<?> waterFogColor;
    private Expression<?> foliageColor;
    private Expression<?> dryFoliageColor;
    private Expression<?> grassColor;
    private Expression<String> grassColorModifier;
    private Expression<ParticleOption> particle;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(SecBiomeRegister.BiomeEffectsEvent.class)) {
            Skript.error((String)"'effects' section can only be used in a `register new biome` section.");
            return false;
        }
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.fogColor = (Expression)container.getOptional("fog_color", false);
        this.skyColor = (Expression)container.getOptional("sky_color", false);
        this.waterColor = (Expression)container.getOptional("water_color", false);
        this.waterFogColor = (Expression)container.getOptional("water_fog_color", false);
        this.foliageColor = (Expression)container.getOptional("foliage_color", false);
        this.dryFoliageColor = (Expression)container.getOptional("dry_foliage_color", false);
        this.grassColor = (Expression)container.getOptional("grass_color", false);
        this.grassColorModifier = (Expression)container.getOptional("grass_color_modifier", false);
        this.particle = (Expression)container.getOptional("particle", false);
        return this.fogColor != null && this.skyColor != null && this.waterColor != null && this.waterFogColor != null;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        if (!(event instanceof SecBiomeRegister.BiomeEffectsEvent)) {
            return super.walk(event, false);
        }
        SecBiomeRegister.BiomeEffectsEvent effectsEvent = (SecBiomeRegister.BiomeEffectsEvent)event;
        BiomeDefinition.Builder builder = effectsEvent.getBiomeBuilder();
        builder.fogColor(this.getColor(this.fogColor.getSingle(event)));
        builder.skyColor(this.getColor(this.skyColor.getSingle(event)));
        builder.waterColor(this.getColor(this.waterColor.getSingle(event)));
        builder.waterFogColor(this.getColor(this.waterFogColor.getSingle(event)));
        if (this.foliageColor != null) {
            builder.foliageColorOverride(this.getColor(this.foliageColor.getSingle(event)));
        }
        if (this.dryFoliageColor != null) {
            builder.dryFoliageColorrOverride(this.getColor(this.dryFoliageColor.getSingle(event)));
        }
        if (this.grassColor != null) {
            builder.grassColorOverride(this.getColor(this.grassColor.getSingle(event)));
        }
        if (this.grassColorModifier != null) {
            builder.grassColorModifier(this.grassColorModifier.getOptionalSingle(event).orElse("none"));
        }
        if (this.particle != null) {
            builder.particle((ParticleOption)this.particle.getSingle(event));
        }
        return super.walk(event, false);
    }

    private int getColor(Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            return color.asBukkitColor().asRGB();
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i;
        }
        return 0;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "biome effects";
    }

    static {
        Class[] colorClasses = new Class[]{Color.class, Integer.class};
        SimpleEntryValidator builder = SimpleEntryValidator.builder();
        builder.addRequiredEntry("fog_color", colorClasses);
        builder.addRequiredEntry("sky_color", colorClasses);
        builder.addRequiredEntry("water_color", colorClasses);
        builder.addRequiredEntry("water_fog_color", colorClasses);
        builder.addOptionalEntry("foliage_color", colorClasses);
        builder.addOptionalEntry("dry_foliage_color", colorClasses);
        builder.addOptionalEntry("grass_color", colorClasses);
        builder.addOptionalEntry("grass_color_modifier", String.class);
        builder.addOptionalEntry("particle", ParticleOption.class);
        VALIDATOR = builder.build();
        Skript.registerSection(SecBiomeSpecialEffects.class, (String[])new String[]{"effects"});
    }
}

