/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections.dialog.bodies;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.util.McUtils;
import com.shanebeestudios.nms.elements.sections.dialog.event.DialogRegisterEvent;
import com.shanebeestudios.nms.elements.sections.dialog.event.PlainMessageEvent;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dialog.body.DialogBody;
import net.minecraft.server.dialog.body.PlainMessage;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Dialog - Plain Message Body")
@Description(value={"A multiline label for a dialog.", "See [**Plain Message**](https://minecraft.wiki/w/Dialog#plain_message) on McWiki for further details.", "**Entries**:", "- `contents` = A string/text component that will be seen in a dialog.", "- `width` = Integer value between 1 and 1024 \u2014 Maximum width of message. Defaults to 200. [Optional]"})
@Examples(value={"add plain message body:", "\tcontents: mini message from \"Do you want to break this block?\"", "\twidth: 150"})
@Since(value={"1.3.0"})
public class SecPlainMessageBody
extends Section {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private Expression<?> contents;
    private Expression<Integer> width;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(new Class[]{DialogRegisterEvent.class, PlainMessageEvent.class})) {
            Skript.error((String)"Plain message body can only be applied in a 'body' section or 'description' section of an item body.");
            return false;
        }
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.contents = (Expression)container.getOptional("contents", false);
        this.width = (Expression)container.getOptional("width", true);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        TriggerItem next = this.getNext();
        Component contents = McUtils.getNMSComponent(this.contents.getSingle(event));
        if (contents == null) {
            this.error("Content is null: " + this.contents.toString(event, true));
            return next;
        }
        int width = (Integer)this.width.getSingle(event);
        PlainMessage plainMessage = new PlainMessage(contents, width);
        if (event instanceof DialogRegisterEvent) {
            DialogRegisterEvent dialogRegisterEvent = (DialogRegisterEvent)event;
            dialogRegisterEvent.addBody((DialogBody)plainMessage);
        } else if (event instanceof PlainMessageEvent) {
            PlainMessageEvent plainMessageEvent = (PlainMessageEvent)event;
            plainMessageEvent.setPlainMessage(plainMessage);
        }
        return next;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "add plain message body";
    }

    static {
        Class[] compClasses = new Class[]{String.class, ComponentWrapper.class};
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("contents", null, false, compClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("width", (Expression)new SimpleLiteral((Object)200, true), true, Integer.class));
        Skript.registerSection(SecPlainMessageBody.class, (String[])new String[]{"add (text|plain message) body"});
    }
}

