/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections.dialog.inputs;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.util.McUtils;
import com.shanebeestudios.nms.elements.sections.dialog.event.DialogRegisterEvent;
import com.shanebeestudios.nms.elements.sections.dialog.event.OptionsEvent;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dialog.Input;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.server.dialog.input.SingleOptionInput;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.SectionEntryData;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Dialog - Single Option Input")
@Description(value={"A preset option selection input to be used in an `inputs` section of a dialog.", "See [**Input Control on SkNMS wiki**](https://github.com/ShaneBeee/SkNMS/wiki/Dialogs#input-control)and [**Input Control on McWiki**](https://minecraft.wiki/w/Dialog#Input_control_format) for further info.", "**Entries**:", "- `key` = String identifier of value used when submitting data, must be a valid template argument (letters, digits and _).", "- `label` = A string/text component to be displayed to the left of the input.", "- `label_visible` = Controls if the label is visible. Defaults to true.", "- `width` = Integer value between 1 and 1024 \u2014 The width of the input. Defaults to 200.", "- `options` = A section for adding options. See [**options**](https://github.com/ShaneBeee/SkNMS/wiki/Dialogs#options) for more info."})
@Examples(value={"add single option input:", "\tkey: \"le_key\"", "\tlabel: \"Choose favorite animal\"", "\toptions:", "\t\tadd options entity:", "\t\t\tdisplay: \"cat\"", "\t\tadd options entity:", "\t\t\tdisplay: \"dog\"", "\t\tadd options entity:", "\t\t\tdisplay: \"turtle\"", "\t\tadd options entity:", "\t\t\tdisplay: \"spider\""})
@Since(value={"1.3.0"})
public class SecSingleOptionInput
extends Section {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private Expression<String> key;
    private Expression<?> label;
    private Expression<Boolean> labelVisible;
    private Expression<Integer> width;
    private Trigger options;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(DialogRegisterEvent.class)) {
            Skript.error((String)"A single option input can only be used in an 'inputs' section of a dialog.");
            return false;
        }
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.key = (Expression)container.getOptional("key", false);
        this.label = (Expression)container.getOptional("label", false);
        this.labelVisible = (Expression)container.getOptional("label_visible", false);
        this.width = (Expression)container.getOptional("width", false);
        SectionNode optionsNode = (SectionNode)container.getOptional("options", false);
        if (optionsNode != null) {
            this.options = this.loadCode(optionsNode, "options", new Class[]{OptionsEvent.class});
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Integer intSingle;
        Boolean single;
        TriggerItem next = this.getNext();
        String key = (String)this.key.getSingle(event);
        if (key == null) {
            return next;
        }
        Object labelWrapped = this.label.getSingle(event);
        Component label = McUtils.getNMSComponent(labelWrapped);
        if (label == null) {
            this.error("Label is invalid: " + this.label.toString(event, true));
            return next;
        }
        boolean labelVisible = true;
        if (this.labelVisible != null && (single = (Boolean)this.labelVisible.getSingle(event)) != null) {
            labelVisible = single;
        }
        int width = 200;
        if (this.width != null && (intSingle = (Integer)this.width.getSingle(event)) != null) {
            width = intSingle;
        }
        OptionsEvent optionsEvent = new OptionsEvent();
        Variables.withLocalVariables((Event)event, (Event)optionsEvent, () -> Trigger.walk((TriggerItem)this.options, (Event)optionsEvent));
        if (event instanceof DialogRegisterEvent) {
            DialogRegisterEvent actionEvent = (DialogRegisterEvent)event;
            SingleOptionInput input = new SingleOptionInput(width, optionsEvent.getEntries(), label, labelVisible);
            actionEvent.addInput(new Input(key, (InputControl)input));
        }
        return next;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "add single option input";
    }

    static {
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("key", null, false, String.class));
        Class[] compClasses = new Class[]{String.class, ComponentWrapper.class};
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("label", null, false, compClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("label_visible", null, true, Boolean.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("width", (Expression)new SimpleLiteral((Object)200, true), true, Integer.class));
        VALIDATOR.addEntryData((EntryData)new SectionEntryData("options", null, false));
        Skript.registerSection(SecSingleOptionInput.class, (String[])new String[]{"add single option input"});
    }
}

