/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.world;

import com.mojang.datafixers.util.Pair;
import com.shanebeestudios.nms.api.util.McUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockApi {
    protected BlockApi() {
    }

    @Nullable
    public static Pair<Location, BlockData> getForPlacement(@NotNull org.bukkit.entity.Player player, int maxDistance) {
        return BlockApi.getForPlacement(player, maxDistance, player.getInventory().getItemInMainHand());
    }

    @Nullable
    public static Pair<Location, BlockData> getForPlacement(@NotNull org.bukkit.entity.Player player, int maxDistance, ItemStack itemStack) {
        ServerPlayer serverPlayer = McUtils.getServerPlayer(player);
        if (itemStack == null) {
            return null;
        }
        net.minecraft.world.item.ItemStack handItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Item item = handItem.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockHitResult blockHitResult = (BlockHitResult)serverPlayer.pick((double)maxDistance, 1.0f, false);
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext((Player)serverPlayer, InteractionHand.MAIN_HAND, handItem, blockHitResult);
            BlockState stateForPlacement = blockItem.getBlock().getStateForPlacement(blockPlaceContext);
            if (stateForPlacement != null) {
                BlockData blockData = McUtils.getBlockDataFromState(stateForPlacement);
                Location location = McUtils.getLocation(blockPlaceContext.getClickedPos(), blockPlaceContext.getLevel());
                return Pair.of((Object)location, (Object)blockData);
            }
        }
        return null;
    }

    @Nullable
    public static BlockData getBlockDataForPlacement(@NotNull org.bukkit.entity.Player player, int maxDistance) {
        Pair<Location, BlockData> forPlacement = BlockApi.getForPlacement(player, maxDistance);
        if (forPlacement != null) {
            return (BlockData)forPlacement.getSecond();
        }
        return null;
    }

    @Nullable
    public static BlockData getBlockDataForPlacement(@NotNull org.bukkit.entity.Player player, int maxDistance, ItemStack itemStack) {
        Pair<Location, BlockData> forPlacement = BlockApi.getForPlacement(player, maxDistance, itemStack);
        if (forPlacement != null) {
            return (BlockData)forPlacement.getSecond();
        }
        return null;
    }

    @Nullable
    public static BlockData getBlockDataForPlacement(@NotNull org.bukkit.entity.Player player, @NotNull Block hitBlock, @NotNull Location hitLocation, @NotNull BlockFace face) {
        ItemStack handItem = player.getInventory().getItemInMainHand();
        return BlockApi.getBlockDataForPlacement(player, hitBlock, hitLocation, face, handItem);
    }

    @Nullable
    public static BlockData getBlockDataForPlacement(@NotNull org.bukkit.entity.Player player, @NotNull Block hitBlock, @NotNull Location hitLocation, @NotNull BlockFace face, @NotNull ItemStack itemStack) {
        ServerPlayer serverPlayer = McUtils.getServerPlayer(player);
        BlockPos hitTarget = McUtils.getPos(hitBlock.getLocation());
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Vec3 hitPosition = McUtils.getVec3(hitLocation);
        Direction direction = McUtils.getDirection(face);
        return BlockApi.getBlockDataForPlacement(serverPlayer, hitTarget, hitPosition, direction, nmsItemStack);
    }

    @Nullable
    private static BlockData getBlockDataForPlacement(@NotNull ServerPlayer serverPlayer, @NotNull BlockPos hitTarget, @NotNull Vec3 hitPosition, @NotNull Direction direction, @NotNull net.minecraft.world.item.ItemStack itemStack) {
        BlockItem blockItem;
        BlockState stateForPlacement;
        BlockHitResult hit = new BlockHitResult(hitPosition, direction, hitTarget, false);
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext((Player)serverPlayer, InteractionHand.MAIN_HAND, itemStack, hit);
        Item item = itemStack.getItem();
        if (item instanceof BlockItem && (stateForPlacement = (blockItem = (BlockItem)item).getBlock().getStateForPlacement(blockPlaceContext)) != null) {
            return McUtils.getBlockDataFromState(stateForPlacement);
        }
        return null;
    }

    @Deprecated(forRemoval=true, since="1.7.1")
    public static float getDestroyProgress(org.bukkit.entity.Player player, Block bukkitBlock) {
        BlockState state = McUtils.getBlockStateFromBlock(bukkitBlock);
        Pair<ServerLevel, BlockPos> levelPos = McUtils.getLevelPos(bukkitBlock.getLocation());
        ServerPlayer serverPlayer = McUtils.getServerPlayer(player);
        return state.getDestroyProgress((Player)serverPlayer, (BlockGetter)levelPos.getFirst(), (BlockPos)levelPos.getSecond());
    }
}

