/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.api.world;

import com.shanebeestudios.nms.api.util.McUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ChunkApi {
    private ChunkApi() {
    }

    @NotNull
    public static LevelChunk getLevelChunk(@NotNull Chunk chunk) {
        return McUtils.getLevelChunk(chunk);
    }

    @NotNull
    public static List<Player> getTicketHolders(@NotNull Chunk chunk) {
        LevelChunk levelChunk = ChunkApi.getLevelChunk(chunk);
        ServerLevel level = (ServerLevel)levelChunk.getLevel();
        ChunkMap chunkMap = level.getChunkSource().chunkMap;
        ArrayList<Player> players = new ArrayList<Player>();
        chunkMap.getPlayers(levelChunk.getPos(), false).forEach(serverPlayer -> players.add((Player)serverPlayer.getBukkitEntity()));
        return players;
    }

    public static float getEffectiveDifficulty(Chunk chunk) {
        LevelChunk levelChunk = ChunkApi.getLevelChunk(chunk);
        Level level = levelChunk.getLevel();
        Difficulty difficulty = level.getDifficulty();
        long dayTime = level.getDayTime();
        long inhabitedTime = levelChunk.getInhabitedTime();
        float moonBrightness = level.getMoonBrightness();
        DifficultyInstance difficultyInstance = new DifficultyInstance(difficulty, dayTime, inhabitedTime, moonBrightness);
        return difficultyInstance.getEffectiveDifficulty();
    }
}

