/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.registry.BiomeDefinition;
import com.shanebeestudios.nms.elements.sections.SecBiomeRegister;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Apply Biome Definition Tag")
@Description(value={"Used in a `tags` section of the biome registration section, you can specify which biome tags for your biome to be included in."})
@Examples(value={"registry registration:", "\tregister new biome:", "\t\tid: \"skbee:colorful_forest\"", "\t\thas_precipitation: true", "\t\ttemperature: 0.7", "\t\tdownfall: 0.8", "\t\ttags:", "\t\t\tapply to tag \"minecraft:has_structure/village_taiga\"", "\t\t\tapply to tag \"minecraft:is_forest\""})
@Since(value={"1.1.0"})
public class EffApplyBiomeTag
extends Effect {
    private Expression<String> strings;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.strings = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        if (event instanceof SecBiomeRegister.BiomeEffectsEvent) {
            SecBiomeRegister.BiomeEffectsEvent effectsEvent = (SecBiomeRegister.BiomeEffectsEvent)event;
            BiomeDefinition.Builder builder = effectsEvent.getBiomeBuilder();
            for (String string : (String[])this.strings.getArray(event)) {
                NamespacedKey namespacedKey;
                if (string.startsWith("#")) {
                    string = string.substring(1);
                }
                if ((namespacedKey = Util.getNamespacedKey((String)string, (boolean)false)) != null && builder.addTag(namespacedKey)) continue;
                String tag = namespacedKey != null ? namespacedKey.toString() : string;
                this.warningRegex("Invalid tag '" + tag + "'", "\".+\"");
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "apply to biome tag[s] " + this.strings.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffApplyBiomeTag.class, (String[])new String[]{"apply to [biome] tag[s] %strings%"});
    }
}

