/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.world.WorldApi;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

@Name(value="Biome Fill")
@Description(value={"Fill a biome within 2 locations. Optionally only replace a specific biome.", "Supports keys for custom biomes.", "This will also refresh biomes to players."})
@Examples(value={"fill biome within {_loc1} and {_loc2} with mc key from \"terralith:moonlit_valley\"", "fill biome within {_loc1} and {_loc2} with mc key from \"terralith:moonlit_valley\" to replace plains"})
@Since(value={"1.0.0"})
public class EffBiomeFill
extends Effect {
    private Expression<Location> loc1;
    private Expression<Location> loc2;
    private Expression<?> object;
    private Expression<?> replace;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.loc1 = exprs[0];
        this.loc2 = exprs[1];
        this.object = exprs[2];
        this.replace = exprs[3];
        return true;
    }

    protected void execute(Event event) {
        Location loc1 = (Location)this.loc1.getSingle(event);
        Location loc2 = (Location)this.loc2.getSingle(event);
        if (loc1 == null || loc2 == null) {
            return;
        }
        World world = loc1.getWorld();
        if (world == null || world != loc2.getWorld()) {
            return;
        }
        NamespacedKey biomeKey = this.getKey(this.object.getSingle(event));
        if (biomeKey == null) {
            return;
        }
        if (this.replace != null) {
            NamespacedKey replaceKey = this.getKey(this.replace.getSingle(event));
            if (replaceKey == null) {
                return;
            }
            WorldApi.fillBiome(loc1, loc2, biomeKey, replaceKey);
        } else {
            WorldApi.fillBiome(loc1, loc2, biomeKey);
        }
        BoundingBox boundingBox = BoundingBox.of((Location)loc1, (Location)loc2);
        for (Chunk chunk : world.getIntersectingChunks(boundingBox)) {
            world.refreshChunk(chunk.getX(), chunk.getZ());
        }
    }

    private NamespacedKey getKey(Object object) {
        if (object instanceof NamespacedKey) {
            NamespacedKey nk = (NamespacedKey)object;
            return nk;
        }
        if (object instanceof Biome) {
            Biome biome = (Biome)object;
            return biome.getKey();
        }
        return null;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String replace = this.replace != null ? " to replace " + this.replace.toString(e, d) : "";
        return "fill biome within " + this.loc1.toString(e, d) + " and " + this.loc2.toString(e, d) + "with " + this.object.toString(e, d) + replace;
    }

    static {
        Skript.registerEffect(EffBiomeFill.class, (String[])new String[]{"fill biome within %location% and %location% with %namespacedkey/biome% [to replace %-namespacedkey/biome%]"});
    }
}

