/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.world.StructureApi;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Place Feature")
@Description(value={"Place a [**configured feature**](https://minecraft.wiki/w/Configured_feature) or [**placed feature**](https://minecraft.wiki/w/Placed_feature) at a location.", "Note: Sometimes the blocks will place, but won't update client side. This is a Minecraft bug.", "Simple solution is to use SkBee's refresh chunk effect (This will resend chunks to players).", "", "**Notes on Placed Features**:", "- When placing a placed feature, if the rules don't match its predicate, it won't place. Some features require specific biomes.", "- Placed features are tested at 0,0,0 in a chunk, therefor your exact location will not be used."})
@Examples(value={"place configured feature \"minecraft:trees_plains\" at target block", "place placed feature \"minecraft:pale_moss_patch\" at target block"})
@Since(value={"1.2.0"})
public class EffPlaceFeature
extends Effect {
    private Expression<?> feature;
    private Expression<Location> location;
    private boolean placed;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.feature = exprs[0];
        this.location = Direction.combine(exprs[1], exprs[2]);
        this.placed = parseResult.hasTag("placed");
        return true;
    }

    protected void execute(Event event) {
        NamespacedKey key;
        Object feature = this.feature.getSingle(event);
        if (feature instanceof String) {
            String string = (String)feature;
            key = Util.getNamespacedKey((String)string, (boolean)false);
        } else if (feature instanceof NamespacedKey) {
            NamespacedKey nk;
            key = nk = (NamespacedKey)feature;
        } else {
            return;
        }
        Location location = (Location)this.location.getSingle(event);
        if (key == null || location == null) {
            return;
        }
        if (this.placed) {
            Location chunkLoc = location.getChunk().getBlock(0, 0, 0).getLocation();
            StructureApi.placePlacedFeature(key, chunkLoc);
        } else {
            StructureApi.placeConfiguredFeature(key, location);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        String placed = this.placed ? "placed" : "configured";
        return new SyntaxStringBuilder(event, debug).append(new Object[]{"place", placed, "feature", this.feature}).append(this.location).toString();
    }

    static {
        Skript.registerEffect(EffPlaceFeature.class, (String[])new String[]{"place (configured|:placed) feature %string/namespacedkey% %direction% %location%"});
    }
}

