/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.registry.DumpRegistry;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Registry Object Serialization")
@Description(value={"Serialize a registry object to a json file.", "This will serialize to Minecraft's datapack format and output to the `plugins/SkNMS/data` folder."})
@Examples(value={"serialize my:custom_biome to json file", "serialize minecraft:sharpness to datapack file", "serialize all biomes to file", "serialize all enchantments to file"})
@Since(value={"1.2.0"})
public class EffRegistrySerialization
extends Effect {
    private Expression<?> object;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.object = LiteralUtils.defendExpression(exprs[0]);
        return true;
    }

    protected void execute(Event event) {
        for (Object object : this.object.getArray(event)) {
            DumpRegistry.dumpObject(object);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "serialize " + this.object.toString(event, debug) + " to datapack file";
    }

    static {
        Skript.registerEffect(EffRegistrySerialization.class, (String[])new String[]{"(dump|serialize) %" + DumpRegistry.PATTERN + "% to [json|data[ ]pack] file"});
    }
}

