/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections.dialog.actions;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.util.McUtils;
import com.shanebeestudios.nms.elements.sections.dialog.event.DialogRegisterEvent;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.ActionButton;
import net.minecraft.server.dialog.CommonButtonData;
import net.minecraft.server.dialog.action.CustomAll;
import net.minecraft.server.dialog.action.StaticAction;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Dialog - Action Button")
@Description(value={"Add an action button to a dialog.", "Only some entries will be discussed here, for further info please see [**Action Format**](https://minecraft.wiki/w/Dialog#Action_format) on McWiki.", "You can use either a [**Static Action**](https://minecraft.wiki/w/Dialog#Static_action_types) with the `action` section,", "or you can use a [**Custom Dynmaic Action**](https://minecraft.wiki/w/Dialog#dynamic/custom) with the `id` and `additions` entries.", "**Entries**:", "- `label` = The name on your button, accepts a string or text component/mini message (from SkBee).", "- `tooltip` = The hover message, accepts a string or text component/mini message (from SkBee).", "- `action` = A click event (from SkBee), also called a [**Static Action**](https://minecraft.wiki/w/Dialog#Static_action_types). This is what happens when the player clicks the button.", "- `id` = The id of a [**Custom Dynmaic Action**](https://minecraft.wiki/w/Dialog#dynamic/custom). This will fire the 'Dynamic Action Button Click' event along with the provided data from an input.", "- `additions` = An additional NBT compound to go along with your custom dynamic action."})
@Examples(value={"add static action button:", "\tlabel: mini message from \"Creative Gamemode\"", "\ttooltip: mini message from \"Switch to creative gamemode\"", "\twidth: 200", "\taction: click event to run command \"gamemode creative\"", "", "add dynamic action button:", "\tlabel: \"Spawn\"", "\ttooltip: \"Teleport yoursel to spawn!\"", "\tid: \"custom:teleport_to_spawn\""})
@Since(value={"1.3.0"})
public class SecActionButton
extends Section {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private boolean isStatic;
    private boolean exitAction;
    private Expression<?> label;
    private Expression<?> tooltip;
    private Expression<Integer> width;
    private Expression<net.kyori.adventure.text.event.ClickEvent> action;
    private Expression<?> id;
    private Expression<NBTCompound> additions;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(DialogRegisterEvent.class)) {
            Skript.error((String)"An action button can only be used in an 'actions' section.");
            return false;
        }
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.isStatic = parseResult.hasTag("static");
        String currentEventName = this.getParser().getCurrentEventName();
        this.exitAction = currentEventName != null && currentEventName.equalsIgnoreCase("exit_action");
        this.label = (Expression)container.getOptional("label", false);
        this.tooltip = (Expression)container.getOptional("tooltip", false);
        this.width = (Expression)container.getOptional("width", true);
        if (this.isStatic) {
            this.action = (Expression)container.getOptional("action", false);
        } else {
            this.id = (Expression)container.getOptional("id", false);
            this.additions = (Expression)container.getOptional("additions", false);
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Object tooltipSingle;
        TriggerItem next = this.getNext();
        Component label = McUtils.getNMSComponent(this.label.getSingle(event));
        Optional<Object> tooltip = Optional.empty();
        if (this.tooltip != null && (tooltipSingle = this.tooltip.getSingle(event)) != null) {
            tooltip = Optional.of(McUtils.getNMSComponent(tooltipSingle));
        }
        int width = (Integer)this.width.getSingle(event);
        CommonButtonData buttonData = new CommonButtonData(label, tooltip, width);
        if (event instanceof DialogRegisterEvent) {
            DialogRegisterEvent actionEvent = (DialogRegisterEvent)event;
            if (this.isStatic) {
                net.kyori.adventure.text.event.ClickEvent action = this.action != null ? (net.kyori.adventure.text.event.ClickEvent)this.action.getSingle(event) : null;
                Optional actionButton = action != null ? Optional.of(new StaticAction(SecActionButton.toVanilla(action))) : Optional.empty();
                ActionButton button = new ActionButton(buttonData, actionButton);
                if (this.exitAction) {
                    actionEvent.setExitActionButton(button);
                } else {
                    actionEvent.addActionButton(button);
                }
            } else {
                NBTCompound nbtCompound;
                NamespacedKey id;
                Object idSingle = this.id.getSingle(event);
                if (idSingle instanceof String) {
                    String string = (String)idSingle;
                    id = NamespacedKey.fromString((String)string);
                } else if (idSingle instanceof NamespacedKey) {
                    NamespacedKey nsk;
                    id = nsk = (NamespacedKey)idSingle;
                } else {
                    return next;
                }
                ResourceLocation resourceLocation = McUtils.getResourceLocation(id);
                Optional<Object> additions = Optional.empty();
                if (this.additions != null && (nbtCompound = (NBTCompound)this.additions.getSingle(event)) != null) {
                    additions = Optional.of((CompoundTag)nbtCompound.getCompound());
                }
                Optional<CustomAll> actionButton = Optional.of(new CustomAll(resourceLocation, additions));
                ActionButton button = new ActionButton(buttonData, actionButton);
                if (this.exitAction) {
                    actionEvent.setExitActionButton(button);
                } else {
                    actionEvent.addActionButton(button);
                }
            }
        }
        return next;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String type = this.isStatic ? "static" : "dynamic";
        return "add " + type + " action button";
    }

    private static ClickEvent toVanilla(net.kyori.adventure.text.event.ClickEvent clickEvent) {
        TextComponent textComponent = (TextComponent)net.kyori.adventure.text.Component.text((String)"t").clickEvent(clickEvent);
        Component vanilla = PaperAdventure.asVanilla((net.kyori.adventure.text.Component)textComponent);
        return vanilla.getStyle().getClickEvent();
    }

    static {
        Class[] compClasses = new Class[]{String.class, ComponentWrapper.class};
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("label", null, false, compClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("tooltip", null, true, compClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("width", (Expression)new SimpleLiteral((Object)150, true), true, Integer.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("action", null, true, net.kyori.adventure.text.event.ClickEvent.class));
        Class[] idClasses = new Class[]{String.class, NamespacedKey.class};
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("id", null, true, idClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("additions", null, true, NBTCompound.class));
        Skript.registerSection(SecActionButton.class, (String[])new String[]{"add (:static|dynamic) action button"});
    }
}

